/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.gift.utils;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganizationUtils {
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;

    public OrganizationDto getCurUserOrg() {
        RestResponse response = this.customerExtQueryApi.queryCurrentUserOrgId();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)response);
        RestResponse orgAndOrgInfoRespDtoResponse = this.organizationQueryApi.queryOrgAndOrgInfo(orgId);
        OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)RestResponseHelper.extractData((RestResponse)orgAndOrgInfoRespDtoResponse);
        if (Objects.nonNull(orgInfoRespDto)) {
            return orgInfoRespDto.getOrganizationDto();
        }
        return null;
    }

    public Long getCurUserOrgId() {
        RestResponse response = this.customerExtQueryApi.queryCurrentUserOrgId();
        return (Long)RestResponseHelper.extractData((RestResponse)response);
    }

    public Long getDealerOrgId(Long customerId) {
        Long dealerOrgId = null;
        if (customerId != null) {
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(Long.valueOf(customerId)));
            if (customerRespDto != null) {
                dealerOrgId = customerRespDto.getMerchantId();
            }
        } else {
            dealerOrgId = this.getCurUserOrgId();
        }
        return dealerOrgId;
    }

    public Long getDealerOrgIdByShopId(Long shopId) {
        SellerRespDto sellerRespDto;
        if (shopId == null) {
            return null;
        }
        ShopBaseDto shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(Long.valueOf(shopId)));
        if (shopBaseDto != null && (sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(shopBaseDto.getSellerId()))) != null) {
            return sellerRespDto.getOrganizationId();
        }
        return null;
    }
}

