package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderApplyInfoCreateForAppletReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderApplyInfoCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderApplyInfoUpdateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderAuditReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长申请信息Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长申请信息"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-ICommanderApplyInfoApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-apply-info", url = "${bundle.commander.center.member.api:}")
public interface ICommanderApplyInfoApi {

    /**
     * 新增团长申请信息（小程序使用）
     * @param createReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @PostMapping("/add-for-applet")
    @ApiOperation(value = "新增团长申请信息（小程序使用）", notes = "新增团长申请信息（小程序使用）")
    RestResponse<Long> addCommanderApplyInfoForApplet(@RequestBody @Valid CommanderApplyInfoCreateForAppletReqDto createReqDto);

    /**
     * 新增团长申请信息
     * @param createReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @PostMapping
    @ApiOperation(value = "新增团长申请信息", notes = "新增团长申请信息")
    RestResponse<Long> addCommanderApplyInfo(@RequestBody @Valid CommanderApplyInfoCreateReqDto createReqDto);

    /**
     * 编辑团长申请信息
     * @param id
     * @param updateReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长申请信息", notes = "编辑团长申请信息")
    RestResponse<Void> modifyCommanderApplyInfo(@PathVariable("id") Long id, @RequestBody @Valid CommanderApplyInfoUpdateReqDto updateReqDto);

    /**
     * 删除团长申请信息
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长申请信息", notes = "删除团长申请信息")
    RestResponse<Void> deleteCommanderApplyInfo(@PathVariable("id") Long id);

    /**
     * 批量审核团长申请
     * @param reqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @PostMapping("/batchAudit")
    @ApiOperation(value = "批量审核团长申请", notes = "批量审核团长申请")
    RestResponse<Void> batchAudit(@RequestBody @Valid CommanderAuditReqDto reqDto);

    /**
     * 测试短信发送功能
     * @param targets
     * @param templateCode
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-apply-info")
    @PostMapping("/sms-message")
    @ApiOperation(value = "测试短信发送接口", notes = "测试短信发送功能")
    RestResponse<Void> sendSmsMessage(@RequestParam("targets") String targets,
                                      @RequestParam("templateCode") String templateCode,
                                      @RequestParam("content") String content);

}