package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderComsCfgCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderComsCfgUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长分佣参数配置Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长分佣参数配置"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-ICommanderComsCfgApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-coms-cfg", url = "${bundle.commander.center.member.api:}")
public interface ICommanderComsCfgApi {

    /**
     * 新增团长分佣参数配置
     * @param createReqDto
     * @return
     */
    @PostMapping
    @ApiOperation(value = "新增团长分佣参数配置", notes = "新增团长分佣参数配置")
    RestResponse<Long> addCommanderComsCfg(@RequestBody @Valid CommanderComsCfgCreateReqDto createReqDto);

    /**
     * 编辑团长分佣参数配置
     * @param id
     * @param updateReqDto
     * @return
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长分佣参数配置", notes = "编辑团长分佣参数配置")
    RestResponse<Void> modifyCommanderComsCfg(@PathVariable("id") Long id, @RequestBody @Valid CommanderComsCfgUpdateReqDto updateReqDto);

    /**
     * 删除团长分佣参数配置
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长分佣参数配置", notes = "删除团长分佣参数配置")
    RestResponse<Void> deleteCommanderComsCfg(@PathVariable("id") Long id);
}