package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderCustomerRelationCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderCustomerRelationUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长客户关系Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长客户关系"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-ICommanderCustomerRelationApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-customer-relation", url = "${bundle.commander.center.member.api:}")
public interface ICommanderCustomerRelationApi {

    /**
     * 新增团长客户关系
     * @param createReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-customer-relation")
    @PostMapping
    @ApiOperation(value = "新增团长客户关系", notes = "新增团长客户关系")
    RestResponse<Long> addCommanderCustomerRelation(@RequestBody @Valid CommanderCustomerRelationCreateReqDto createReqDto);

    /**
     * 编辑团长客户关系
     * @param id
     * @param updateReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-customer-relation")
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长客户关系", notes = "编辑团长客户关系")
    RestResponse<Void> modifyCommanderCustomerRelation(@PathVariable("id") Long id, @RequestBody @Valid CommanderCustomerRelationUpdateReqDto updateReqDto);

    /**
     * 删除团长客户关系
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-customer-relation")
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长客户关系", notes = "删除团长客户关系")
    RestResponse<Void> deleteCommanderCustomerRelation(@PathVariable("id") Long id);
}