package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderLevelDefineCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderLevelDefineUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长等级定义Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长等级定义"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-ICommanderLevelDefineApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-level-define", url = "${bundle.commander.center.member.api:}")
public interface ICommanderLevelDefineApi {

    /**
     * 新增团长等级定义
     * @param createReqDto
     * @return
     */
    @PostMapping
    @ApiOperation(value = "新增团长等级定义", notes = "新增团长等级定义")
    RestResponse<Long> addCommanderLevelDefine(@RequestBody @Valid CommanderLevelDefineCreateReqDto createReqDto);

    /**
     * 编辑团长等级定义
     * @param id
     * @param updateReqDto
     * @return
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长等级定义", notes = "编辑团长等级定义")
    RestResponse<Void> modifyCommanderLevelDefine(@PathVariable("id") Long id, @RequestBody @Valid CommanderLevelDefineUpdateReqDto updateReqDto);

    /**
     * 删除团长等级定义
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长等级定义", notes = "删除团长等级定义")
    RestResponse<Void> deleteCommanderLevelDefine(@PathVariable("id") Long id);
}