package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderPointsDetailsCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderPointsDetailsUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长积分明细Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长积分明细"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-ICommanderPointsDetailsApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-points-details", url = "${bundle.commander.center.member.api:}")
public interface ICommanderPointsDetailsApi {

    /**
     * 新增团长积分明细
     * @param createReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-points-details")
    @PostMapping
    @ApiOperation(value = "新增团长积分明细", notes = "新增团长积分明细")
    RestResponse<Long> addCommanderPointsDetails(@RequestBody @Valid CommanderPointsDetailsCreateReqDto createReqDto);

    /**
     * 编辑团长积分明细
     * @param id
     * @param updateReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-points-details")
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长积分明细", notes = "编辑团长积分明细")
    RestResponse<Void> modifyCommanderPointsDetails(@PathVariable("id") Long id, @RequestBody @Valid CommanderPointsDetailsUpdateReqDto updateReqDto);

    /**
     * 删除团长积分明细
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-points-details")
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长积分明细", notes = "删除团长积分明细")
    RestResponse<Void> deleteCommanderPointsDetails(@PathVariable("id") Long id);
}