package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderRankingCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderRankingUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长排行榜Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长排行榜"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-ICommanderRankingApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-ranking", url = "${bundle.commander.center.member.api:}")
public interface ICommanderRankingApi {

    /**
     * 新增团长排行榜
     * @param createReqDto
     * @return
     */
    @PostMapping
    @ApiOperation(value = "新增团长排行榜", notes = "新增团长排行榜")
    RestResponse<Long> addCommanderRanking(@RequestBody @Valid CommanderRankingCreateReqDto createReqDto);

    /**
     * 编辑团长排行榜
     * @param id
     * @param updateReqDto
     * @return
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长排行榜", notes = "编辑团长排行榜")
    RestResponse<Void> modifyCommanderRanking(@PathVariable("id") Long id, @RequestBody @Valid CommanderRankingUpdateReqDto updateReqDto);

    /**
     * 删除团长排行榜
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长排行榜", notes = "删除团长排行榜")
    RestResponse<Void> deleteCommanderRanking(@PathVariable("id") Long id);

    /**
     * 计算团长排行榜
     * @return
     */
    @PostMapping("/calRanking")
    @ApiOperation(value = "计算团长排行榜", notes = "计算团长排行榜")
    RestResponse<Void> calRanking();
}