package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderSettlementCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderSettlementUpdateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderSettlementRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 团长结算记录Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长结算记录"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-ICommanderSettlementApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-settlement", url = "${bundle.commander.center.member.api:}")
public interface ICommanderSettlementApi {

    /**
     * 新增团长结算记录
     * @param createReqDto
     * @return
     */
    @PostMapping
    @ApiOperation(value = "新增团长结算记录", notes = "新增团长结算记录")
    RestResponse<Long> addCommanderSettlement(@RequestBody @Valid CommanderSettlementCreateReqDto createReqDto);

    /**
     * 编辑团长结算记录
     * @param id
     * @param updateReqDto
     * @return
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长结算记录", notes = "编辑团长结算记录")
    RestResponse<Void> modifyCommanderSettlement(@PathVariable("id") Long id, @RequestBody @Valid CommanderSettlementUpdateReqDto updateReqDto);

    /**
     * 删除团长结算记录
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长结算记录", notes = "删除团长结算记录")
    RestResponse<Void> deleteCommanderSettlement(@PathVariable("id") Long id);

    /**
     * 手工批量结算
     * @param ids
     * @return
     */
    @PostMapping("/batch/manual-settle")
    @ApiOperation(value = "手工批量结算", notes = "手工批量结算")
    RestResponse<Void> manualSettle(@RequestParam("ids") List<Long> ids);
}