package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderStatisticsCreateReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderStatisticsUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 团长统计信息Api
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长统计信息"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-ICommanderStatisticsApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-statistics", url = "${bundle.commander.center.member.api:}")
public interface ICommanderStatisticsApi {

    /**
     * 新增团长统计信息
     * @param createReqDto
     * @return
     */
    @PostMapping
    @ApiOperation(value = "新增团长统计信息", notes = "新增团长统计信息")
    RestResponse<Long> addCommanderStatistics(@RequestBody @Valid CommanderStatisticsCreateReqDto createReqDto);

    /**
     * 编辑团长统计信息
     * @param id
     * @param updateReqDto
     * @return
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "编辑团长统计信息", notes = "编辑团长统计信息")
    RestResponse<Void> modifyCommanderStatistics(@PathVariable("id") Long id, @RequestBody @Valid CommanderStatisticsUpdateReqDto updateReqDto);

    /**
     * 删除团长统计信息
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除团长统计信息", notes = "删除团长统计信息")
    RestResponse<Void> deleteCommanderStatistics(@PathVariable("id") Long id);
}