package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 团长申请信息（小程序使用）CreateReqDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderApplyInfoCreateForAppletReqDto", description = "团长申请信息（小程序使用）CreateReqDto")
public class CommanderApplyInfoCreateForAppletReqDto extends BaseReqDto {
    /**
     * extension、tenant_id、instance_id、create_person、create_time、update_person、update_time
     * 以上字段存于父类中
     */
    @ApiModelProperty(name = "orgId", value = "组织ID")
    private Long orgId;

    @ApiModelProperty(name = "type", value = "业务类型：1团长招募，2团长推广")
    private Integer type;

    @NotNull
    @ApiModelProperty(name = "memberId", value = "会员ID", required = true)
    private Long memberId;

    @NotNull
    @ApiModelProperty(name = "commanderNo", value = "会员编号", required = true)
    private String commanderNo;

    @ApiModelProperty(name = "distribType", value = "分销类型：1佣金分销，2加价分销")
    private Integer distribType;

    @ApiModelProperty(name = "cmdLabel", value = "分销员标签")
    private String cmdLabel;

    @ApiModelProperty(name = "idCardNo", value = "身份证号")
    private String idCardNo;

    @ApiModelProperty(name = "commanderShopName", value = "团长店铺")
    private String commanderShopName;

    @ApiModelProperty(name = "recommendPhone", value = "推荐人手机号码")
    private String recommendPhone;

    @ApiModelProperty(name = "receivingPhone", value = "团长收货备用手机")
    private String receivingPhone;

    @ApiModelProperty(name = "receivingProvinceCode", value = "收货人：省编码")
    private String receivingProvinceCode;

    @ApiModelProperty(name = "receivingCityCode", value = "收货人：市编码")
    private String receivingCityCode;

    @ApiModelProperty(name = "receivingDistrictCode", value = "收货人：区编码")
    private String receivingDistrictCode;

    @ApiModelProperty(name = "receivingProvinceName", value = "收货人：省名称")
    private String receivingProvinceName;

    @ApiModelProperty(name = "receivingCityName", value = "收货人：市名称")
    private String receivingCityName;

    @ApiModelProperty(name = "receivingDistrictName", value = "收货人：区名称")
    private String receivingDistrictName;

    @ApiModelProperty(name = "receivingAddress", value = "收货人：详细地址")
    private String receivingAddress;

    @ApiModelProperty(name = "deliveryType", value = "配送方式：1跟随平台设定，2团长店铺自提，3团长送货上门")
    private Integer deliveryType;

    @ApiModelProperty(name = "isAgreement", value = "是否同意申请协议：1同意，0不同意")
    private Integer isAgreement;

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getDistribType() {
        return distribType;
    }

    public void setDistribType(Integer distribType) {
        this.distribType = distribType;
    }

    public String getCmdLabel() {
        return cmdLabel;
    }

    public void setCmdLabel(String cmdLabel) {
        this.cmdLabel = cmdLabel;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public String getCommanderShopName() {
        return commanderShopName;
    }

    public void setCommanderShopName(String commanderShopName) {
        this.commanderShopName = commanderShopName;
    }

    public String getRecommendPhone() {
        return recommendPhone;
    }

    public void setRecommendPhone(String recommendPhone) {
        this.recommendPhone = recommendPhone;
    }

    public String getReceivingProvinceCode() {
        return receivingProvinceCode;
    }

    public void setReceivingProvinceCode(String receivingProvinceCode) {
        this.receivingProvinceCode = receivingProvinceCode;
    }

    public String getReceivingCityCode() {
        return receivingCityCode;
    }

    public void setReceivingCityCode(String receivingCityCode) {
        this.receivingCityCode = receivingCityCode;
    }

    public String getReceivingDistrictCode() {
        return receivingDistrictCode;
    }

    public void setReceivingDistrictCode(String receivingDistrictCode) {
        this.receivingDistrictCode = receivingDistrictCode;
    }

    public String getReceivingProvinceName() {
        return receivingProvinceName;
    }

    public void setReceivingProvinceName(String receivingProvinceName) {
        this.receivingProvinceName = receivingProvinceName;
    }

    public String getReceivingCityName() {
        return receivingCityName;
    }

    public void setReceivingCityName(String receivingCityName) {
        this.receivingCityName = receivingCityName;
    }

    public String getReceivingDistrictName() {
        return receivingDistrictName;
    }

    public void setReceivingDistrictName(String receivingDistrictName) {
        this.receivingDistrictName = receivingDistrictName;
    }

    public String getReceivingAddress() {
        return receivingAddress;
    }

    public void setReceivingAddress(String receivingAddress) {
        this.receivingAddress = receivingAddress;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Integer getIsAgreement() {
        return isAgreement;
    }

    public void setIsAgreement(Integer isAgreement) {
        this.isAgreement = isAgreement;
    }

    public String getCommanderNo() {
        return commanderNo;
    }

    public void setCommanderNo(String commanderNo) {
        this.commanderNo = commanderNo;
    }

    public String getReceivingPhone() {
        return receivingPhone;
    }

    public void setReceivingPhone(String receivingPhone) {
        this.receivingPhone = receivingPhone;
    }

}