package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 团长客户关系QueryReqDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderCustomerRelationQueryReqDto", description = "团长客户关系QueryReqDto")
public class CommanderCustomerRelationQueryReqDto extends BaseReqDto {
    /**
     * extension、tenant_id、instance_id、create_person、create_time、update_person、update_time
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "commanderId", value = "团长ID")
    private Long commanderId;

    @ApiModelProperty(name = "memberId", value = "会员ID")
    private Long memberId;

    @ApiModelProperty(name = "memberNo", value = "会员编号")
    private String memberNo;

    @ApiModelProperty(name = "phone", value = "会员手机号码")
    private String phone;

    @ApiModelProperty(name = "totalMoney", value = "消费总金额(单位：分钱)")
    private Integer totalMoney;

    @ApiModelProperty(name = "lastMoney", value = "最后一次消费金额(单位：分钱)")
    private Integer lastMoney;

    @ApiModelProperty(name = "lastTime", value = "最后一次消费时间")
    private Date lastTime;

    /************************************************************************************************/

    @ApiModelProperty(name = "startCreateTime", value = "开始-开拓时间，格式：yyyy-MM-dd HH:mm:ss")
    private String startCreateTime;

    @ApiModelProperty(name = "endCreateTime", value = "结束-开拓时间，格式：yyyy-MM-dd HH:mm:ss")
    private String endCreateTime;

    @ApiModelProperty(name = "startLastTime", value = "开始-最后一次消费时间，格式：yyyy-MM-dd HH:mm:ss")
    private String startLastTime;

    @ApiModelProperty(name = "endLastTime", value = "结束-最后一次消费时间，格式：yyyy-MM-dd HH:mm:ss")
    private String endLastTime;

    @ApiModelProperty(name = "isContainMemberInfo", value = "查询是否包含会员档案信息：1是，0否")
    private Integer isContainMemberInfo;

    @ApiModelProperty(name = "cycleType", value = "周期类型：1今日，2本周，3本月，4累计")
    private Integer cycleType;

    @ApiModelProperty(name = "status", value = "客户类型：0全部访客，1已下单客户，2未下单客户，3全部客户")
    private Integer status;

    public Long getCommanderId(){
        return commanderId;
    }

    public void setCommanderId(Long commanderId){
        this.commanderId = commanderId;
    }

    public Long getMemberId(){
        return memberId;
    }

    public void setMemberId(Long memberId){
        this.memberId = memberId;
    }

    public String getMemberNo(){
        return memberNo;
    }

    public void setMemberNo(String memberNo){
        this.memberNo = memberNo;
    }

    public String getPhone(){
        return phone;
    }

    public void setPhone(String phone){
        this.phone = phone;
    }

    public Integer getTotalMoney(){
        return totalMoney;
    }

    public void setTotalMoney(Integer totalMoney){
        this.totalMoney = totalMoney;
    }

    public Integer getLastMoney(){
        return lastMoney;
    }

    public void setLastMoney(Integer lastMoney){
        this.lastMoney = lastMoney;
    }

    public Date getLastTime(){
        return lastTime;
    }

    public void setLastTime(Date lastTime){
        this.lastTime = lastTime;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStartCreateTime() {
        return startCreateTime;
    }

    public void setStartCreateTime(String startCreateTime) {
        this.startCreateTime = startCreateTime;
    }

    public String getEndCreateTime() {
        return endCreateTime;
    }

    public void setEndCreateTime(String endCreateTime) {
        this.endCreateTime = endCreateTime;
    }

    public String getStartLastTime() {
        return startLastTime;
    }

    public void setStartLastTime(String startLastTime) {
        this.startLastTime = startLastTime;
    }

    public String getEndLastTime() {
        return endLastTime;
    }

    public void setEndLastTime(String endLastTime) {
        this.endLastTime = endLastTime;
    }

    public Integer getIsContainMemberInfo() {
        return isContainMemberInfo;
    }

    public void setIsContainMemberInfo(Integer isContainMemberInfo) {
        this.isContainMemberInfo = isContainMemberInfo;
    }

    public Integer getCycleType() {
        return cycleType;
    }

    public void setCycleType(Integer cycleType) {
        this.cycleType = cycleType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}