package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 团长等级参数配置UpdateReqDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderLevelConfigUpdateReqDto", description = "团长等级参数配置UpdateReqDto")
public class CommanderLevelConfigUpdateReqDto extends BaseReqDto {
    /**
     * extension、tenant_id、instance_id、create_person、create_time、update_person、update_time
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "dataType", value = "数据类型：1运行中数据，2社交电商模板数据，3互联网平台模板数据，4社区团购模板数据")
    private Integer dataType;

    @ApiModelProperty(name = "isRealTime", value = "等级更新周期是否实时：1是0否")
    private Integer isRealTime;

    @ApiModelProperty(name = "levelUpdateCycle", value = "等级非实时更新周期：1周，2月，3季度，4年")
    private Integer levelUpdateCycle;

    @ApiModelProperty(name = "levelValidity", value = "等级有效期：1周，2月，3季度，4年，5永久")
    private Integer levelValidity;

    @ApiModelProperty(name = "levelChangeType", value = "等级变动方式：1取最新等级，2取相对大的等级")
    private Integer levelChangeType;

    @ApiModelProperty(name = "recheckDay", value = "等级变动后N天内退货需重新校验")
    private Integer recheckDay;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getDataType() {
        return dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public Integer getIsRealTime() {
        return isRealTime;
    }

    public void setIsRealTime(Integer isRealTime) {
        this.isRealTime = isRealTime;
    }

    public Integer getLevelUpdateCycle() {
        return levelUpdateCycle;
    }

    public void setLevelUpdateCycle(Integer levelUpdateCycle) {
        this.levelUpdateCycle = levelUpdateCycle;
    }

    public Integer getLevelValidity() {
        return levelValidity;
    }

    public void setLevelValidity(Integer levelValidity) {
        this.levelValidity = levelValidity;
    }

    public Integer getLevelChangeType() {
        return levelChangeType;
    }

    public void setLevelChangeType(Integer levelChangeType) {
        this.levelChangeType = levelChangeType;
    }

    public Integer getRecheckDay() {
        return recheckDay;
    }

    public void setRecheckDay(Integer recheckDay) {
        this.recheckDay = recheckDay;
    }
}