package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 团长等级定义UpdateReqDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderLevelDefineUpdateReqDto", description = "团长等级定义UpdateReqDto")
public class CommanderLevelDefineUpdateReqDto extends BaseReqDto {
    /**
     * extension、tenant_id、instance_id、create_person、create_time、update_person、update_time
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "dataType", value = "数据类型：1运行中数据，2社交电商模板数据，3互联网平台模板数据，4社区团购模板数据")
    private Integer dataType;

    @ApiModelProperty(name = "status", value = "状态：0待启用，1已启用，2已禁用")
    private Integer status;

    @ApiModelProperty(name = "level", value = "等级级别：1-12")
    private Integer level;

    @ApiModelProperty(name = "levelNum", value = "等级序号")
    private Integer levelNum;

    @ApiModelProperty(name = "levelNo", value = "等级编码")
    private String levelNo;

    @ApiModelProperty(name = "levelName", value = "等级名称")
    private String levelName;

    @ApiModelProperty(name = "levelReward", value = "等级奖励")
    private Double levelReward;

    @ApiModelProperty(name = "personPoint", value = "个人积分")
    private Integer personPoint;

    @ApiModelProperty(name = "personHistoryPoint", value = "个人累积分")
    private Integer personHistoryPoint;

    @ApiModelProperty(name = "teamPoint", value = "团队积分")
    private Integer teamPoint;

    @ApiModelProperty(name = "teamHistoryPoint", value = "团队累积分")
    private Integer teamHistoryPoint;

    @ApiModelProperty(name = "teamHistoryCount", value = "团队人数")
    private Integer teamHistoryCount;

    @ApiModelProperty(name = "levelTeamCount", value = "达到指定等级要求的团队人数")
    private Integer levelTeamCount;

    @ApiModelProperty(name = "personLevelId", value = "达到指定等级要求的等级id")
    private Long personLevelId;

    @ApiModelProperty(name = "isInitLevel", value = "是否初始等级：1是0否")
    private Integer isInitLevel;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getDataType() {
        return dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public Integer getLevelNum() {
        return levelNum;
    }

    public void setLevelNum(Integer levelNum) {
        this.levelNum = levelNum;
    }

    public String getLevelNo() {
        return levelNo;
    }

    public void setLevelNo(String levelNo) {
        this.levelNo = levelNo;
    }

    public String getLevelName() {
        return levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public Double getLevelReward() {
        return levelReward;
    }

    public void setLevelReward(Double levelReward) {
        this.levelReward = levelReward;
    }

    public Integer getPersonPoint() {
        return personPoint;
    }

    public void setPersonPoint(Integer personPoint) {
        this.personPoint = personPoint;
    }

    public Integer getPersonHistoryPoint() {
        return personHistoryPoint;
    }

    public void setPersonHistoryPoint(Integer personHistoryPoint) {
        this.personHistoryPoint = personHistoryPoint;
    }

    public Integer getTeamPoint() {
        return teamPoint;
    }

    public void setTeamPoint(Integer teamPoint) {
        this.teamPoint = teamPoint;
    }

    public Integer getTeamHistoryPoint() {
        return teamHistoryPoint;
    }

    public void setTeamHistoryPoint(Integer teamHistoryPoint) {
        this.teamHistoryPoint = teamHistoryPoint;
    }

    public Integer getTeamHistoryCount() {
        return teamHistoryCount;
    }

    public void setTeamHistoryCount(Integer teamHistoryCount) {
        this.teamHistoryCount = teamHistoryCount;
    }

    public Integer getLevelTeamCount() {
        return levelTeamCount;
    }

    public void setLevelTeamCount(Integer levelTeamCount) {
        this.levelTeamCount = levelTeamCount;
    }

    public Long getPersonLevelId() {
        return personLevelId;
    }

    public void setPersonLevelId(Long personLevelId) {
        this.personLevelId = personLevelId;
    }

    public Integer getIsInitLevel() {
        return isInitLevel;
    }

    public void setIsInitLevel(Integer isInitLevel) {
        this.isInitLevel = isInitLevel;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }
}