package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 团长订单记录CreateReqDto
 *
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderOrderRecordCreateReqDto", description = "团长订单记录CreateReqDto")
public class CommanderOrderRecordCreateReqDto extends BaseReqDto {
    /**
     * extension、tenant_id、instance_id、create_person、create_time、update_person、update_time
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "commanderId", value = "归属团长ID")
    private Long commanderId;

    @ApiModelProperty(name = "status", value = "订单状态：1已支付，2已退款")
    private Integer status;

    @ApiModelProperty(name = "orderNo", value = "订单编号")
    private String orderNo;

    @ApiModelProperty(name = "refundNo", value = "退款单号")
    private String refundNo;

    @ApiModelProperty(name = "orderTime", value = "订单时间")
    private Date orderTime;

    @ApiModelProperty(name = "refundTime", value = "退款时间")
    private Date refundTime;

    @ApiModelProperty(name = "orderPrice", value = "订单金额（单位：分钱）")
    private Integer orderPrice;

    @ApiModelProperty(name = "userId", value = "用户id")
    private Long userId;

    @ApiModelProperty(name = "recommendUserId", value = "推广用户id")
    private Long recommendUserId;

    @ApiModelProperty(name = "shopNo", value = "店铺编号")
    private String shopNo;

    @ApiModelProperty(name = "tradeCode", value = "交易流水号")
    private String tradeCode;

    @ApiModelProperty(name = "receiverProvince", value = "收货人所在省")
    private String receiverProvince;

    @ApiModelProperty(name = "receiverCity", value = "收货人所在市")
    private String receiverCity;

    @ApiModelProperty(name = "receiverDistrict", value = "收货人所在区")
    private String receiverDistrict;

    @ApiModelProperty(name = "freight", value = "运费金额")
    private Integer freight;

    @ApiModelProperty(name = "payAmount", value = "实付金额")
    private Integer payAmount;

    @ApiModelProperty(name = "discountAmount", value = "优惠总金额")
    private Integer discountAmount;

    @ApiModelProperty(name = "payTime", value = "支付时间")
    private Date payTime;

    /**
     * 收货人姓名
     */
    @ApiModelProperty(name = "receiverName", value = "收货人姓名")
    private String receiverName;

    /**
     * 收货人手机
     */
    @ApiModelProperty(name = "receiverPhone", value = "收货人手机")
    private String receiverPhone;

    /**
     * 支付单号
     */
    @ApiModelProperty(name = "payNo", value = "支付单号")
    private String payNo;

    /**
     * 订单创建时间
     */
    @ApiModelProperty(name = "orderCreateTime", value = "订单创建时间")
    private Date orderCreateTime;

    public Long getCommanderId() {
        return commanderId;
    }

    public void setCommanderId(Long commanderId) {
        this.commanderId = commanderId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRefundNo() {
        return refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public Date getRefundTime() {
        return refundTime;
    }

    public void setRefundTime(Date refundTime) {
        this.refundTime = refundTime;
    }

    public Integer getOrderPrice() {
        return orderPrice;
    }

    public void setOrderPrice(Integer orderPrice) {
        this.orderPrice = orderPrice;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getRecommendUserId() {
        return recommendUserId;
    }

    public void setRecommendUserId(Long recommendUserId) {
        this.recommendUserId = recommendUserId;
    }

    public String getShopNo() {
        return shopNo;
    }

    public void setShopNo(String shopNo) {
        this.shopNo = shopNo;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTradeCode() {
        return tradeCode;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    public String getReceiverProvince() {
        return receiverProvince;
    }

    public void setReceiverProvince(String receiverProvince) {
        this.receiverProvince = receiverProvince;
    }

    public String getReceiverCity() {
        return receiverCity;
    }

    public void setReceiverCity(String receiverCity) {
        this.receiverCity = receiverCity;
    }

    public String getReceiverDistrict() {
        return receiverDistrict;
    }

    public void setReceiverDistrict(String receiverDistrict) {
        this.receiverDistrict = receiverDistrict;
    }

    public Integer getFreight() {
        return freight;
    }

    public void setFreight(Integer freight) {
        this.freight = freight;
    }

    public Integer getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(Integer payAmount) {
        this.payAmount = payAmount;
    }

    public Integer getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(Integer discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverPhone() {
        return receiverPhone;
    }

    public void setReceiverPhone(String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    public String getPayNo() {
        return payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public Date getOrderCreateTime() {
        return orderCreateTime;
    }

    public void setOrderCreateTime(Date orderCreateTime) {
        this.orderCreateTime = orderCreateTime;
    }
}