package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 团长排行榜QueryReqDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderRankingQueryReqDto", description = "团长排行榜QueryReqDto")
public class CommanderRankingQueryReqDto extends BaseReqDto {
    /**
     * extension、tenant_id、instance_id、create_person、create_time、update_person、update_time
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

	@ApiModelProperty(name = "ranking", value = "名次")
	private Integer ranking;

	@ApiModelProperty(name = "dimension", value = "排行维度：1佣金收益，2团队人数，3客户人数")
	private Integer dimension;

	@ApiModelProperty(name = "cycleType", value = "排行周期：1昨日，2本周，3本月，4累计")
	private Integer cycleType;

	@ApiModelProperty(name = "commanderId", value = "团长id")
	private Long commanderId;

	@ApiModelProperty(name = "commanderNo", value = "团长编号")
	private String commanderNo;

	@ApiModelProperty(name = "memberId", value = "会员id")
	private Long memberId;

	@ApiModelProperty(name = "phone", value = "手机号")
	private String phone;

	@ApiModelProperty(name = "value", value = "排行值")
	private Integer value;

	@ApiModelProperty(name = "realName", value = "会员姓名")
	private String realName;

	@ApiModelProperty(name = "avatar", value = "会员头像")
	private String avatar;


	/*******************************************************************************************/

	@ApiModelProperty(name = "queryRealTimeMemberInfo", value = "是否查询实时的会员档案信息：1是，0否")
	private Integer queryRealTimeMemberInfo;


	public Integer getRanking(){
		return ranking;
	}

	public void setRanking(Integer ranking){
		this.ranking = ranking;
	}

	public Integer getDimension(){
		return dimension;
	}

	public void setDimension(Integer dimension){
		this.dimension = dimension;
	}

	public Integer getCycleType(){
		return cycleType;
	}

	public void setCycleType(Integer cycleType){
		this.cycleType = cycleType;
	}

	public Long getCommanderId(){
		return commanderId;
	}

	public void setCommanderId(Long commanderId){
		this.commanderId = commanderId;
	}

	public String getCommanderNo(){
		return commanderNo;
	}

	public void setCommanderNo(String commanderNo){
		this.commanderNo = commanderNo;
	}

	public String getPhone(){
		return phone;
	}

	public void setPhone(String phone){
		this.phone = phone;
	}

	public Integer getValue() {
		return value;
	}

	public void setValue(Integer value) {
		this.value = value;
	}

	public String getRealName() {
		return realName;
	}

	public void setRealName(String realName) {
		this.realName = realName;
	}

	public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

	public Long getMemberId() {
		return memberId;
	}

	public void setMemberId(Long memberId) {
		this.memberId = memberId;
	}

	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}

	public Integer getQueryRealTimeMemberInfo() {
		return queryRealTimeMemberInfo;
	}

	public void setQueryRealTimeMemberInfo(Integer queryRealTimeMemberInfo) {
		this.queryRealTimeMemberInfo = queryRealTimeMemberInfo;
	}
}