package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 团长订单商品信息记录RespDto
 *
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderOrderGoodsRecordRespDto", description = "团长订单商品信息记录RespDto")
public class CommanderOrderGoodsRecordRespDto extends BaseRespDto {
    /**
     * id、extension、tenant_id、instance_id、create_person、create_time、update_person、update_time、dr
     * 以上字段存于父类中
     */

    @ApiModelProperty(name = "commanderOrderId", value = "订单ID")
    private Long commanderOrderId;

    @ApiModelProperty(name = "orderOrRefundNo", value = "订单编号/退款订单编号")
    private String orderOrRefundNo;

    @ApiModelProperty(name = "goodsNo", value = "商品编号")
    private String goodsNo;

    @ApiModelProperty(name = "goodsName", value = "商品名称")
    private String goodsName;

    @ApiModelProperty(name = "goodsUnitPrice", value = "商品单价(单位：分钱)")
    private Integer goodsUnitPrice;

    @ApiModelProperty(name = "goodsNum", value = "商品数量")
    private Integer goodsNum;

    @ApiModelProperty(name = "goodsCategory", value = "商品品类")
    private String goodsCategory;

    @ApiModelProperty(name = "goodsSubCategory", value = "商品子品类")
    private String goodsSubCategory;

    @ApiModelProperty(name = "goodsPrice", value = "商品交易金额(单位：分钱)")
    private Integer goodsPrice;

    @ApiModelProperty(name = "goodsPoints", value = "商品积分")
    private Integer goodsPoints;

    @ApiModelProperty(name = "pointType", value = "积分类型：1本人消费，2客户消费")
    private Integer pointType;

    @ApiModelProperty(name = "comsCalType", value = "分佣计算方式：1按比例计算，2按固定值计算")
    private Integer comsCalType;

    @ApiModelProperty(name = "directComs", value = "直接上级佣金（固定值时，单位：分钱）")
    private Double directComs;

    @ApiModelProperty(name = "indirectComs", value = "间接上级佣金（固定值时，单位：分钱）")
    private Double indirectComs;

    @ApiModelProperty(name = "directPoints", value = "直接上级积分")
    private Double directPoints;

    @ApiModelProperty(name = "indirectPoints", value = "间接上级积分")
    private Double indirectPoints;

    @ApiModelProperty(name = "imageUrl", value = "商品主图片")
    private String imageUrl;

    @ApiModelProperty(name = "goodsPredictComs", value = "商品预估佣金，单位：分钱")
    private Double goodsPredictComs;

    @ApiModelProperty(name = "goodsCostPrice", value = "商品成本价(单位：分钱)")
    private Integer goodsCostPrice;


    public Integer getComsCalType() {
        return comsCalType;
    }

    public void setComsCalType(Integer comsCalType) {
        this.comsCalType = comsCalType;
    }

    public Double getDirectComs() {
        return directComs;
    }

    public void setDirectComs(Double directComs) {
        this.directComs = directComs;
    }

    public Double getIndirectComs() {
        return indirectComs;
    }

    public void setIndirectComs(Double indirectComs) {
        this.indirectComs = indirectComs;
    }

    public Double getDirectPoints() {
        return directPoints;
    }

    public void setDirectPoints(Double directPoints) {
        this.directPoints = directPoints;
    }

    public Double getIndirectPoints() {
        return indirectPoints;
    }

    public void setIndirectPoints(Double indirectPoints) {
        this.indirectPoints = indirectPoints;
    }

    public Long getCommanderOrderId() {
        return commanderOrderId;
    }

    public void setCommanderOrderId(Long commanderOrderId) {
        this.commanderOrderId = commanderOrderId;
    }

    public String getOrderOrRefundNo() {
        return orderOrRefundNo;
    }

    public void setOrderOrRefundNo(String orderOrRefundNo) {
        this.orderOrRefundNo = orderOrRefundNo;
    }

    public String getGoodsNo() {
        return goodsNo;
    }

    public void setGoodsNo(String goodsNo) {
        this.goodsNo = goodsNo;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public Integer getGoodsUnitPrice() {
        return goodsUnitPrice;
    }

    public void setGoodsUnitPrice(Integer goodsUnitPrice) {
        this.goodsUnitPrice = goodsUnitPrice;
    }

    public Integer getGoodsNum() {
        return goodsNum;
    }

    public void setGoodsNum(Integer goodsNum) {
        this.goodsNum = goodsNum;
    }

    public String getGoodsCategory() {
        return goodsCategory;
    }

    public void setGoodsCategory(String goodsCategory) {
        this.goodsCategory = goodsCategory;
    }

    public String getGoodsSubCategory() {
        return goodsSubCategory;
    }

    public void setGoodsSubCategory(String goodsSubCategory) {
        this.goodsSubCategory = goodsSubCategory;
    }

    public Integer getGoodsPrice() {
        return goodsPrice;
    }

    public void setGoodsPrice(Integer goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public Integer getGoodsPoints() {
        return goodsPoints;
    }

    public void setGoodsPoints(Integer goodsPoints) {
        this.goodsPoints = goodsPoints;
    }

    public Integer getPointType() {
        return pointType;
    }

    public void setPointType(Integer pointType) {
        this.pointType = pointType;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Double getGoodsPredictComs() {
        return goodsPredictComs;
    }

    public void setGoodsPredictComs(Double goodsPredictComs) {
        this.goodsPredictComs = goodsPredictComs;
    }

    public Integer getGoodsCostPrice() {
        return goodsCostPrice;
    }

    public void setGoodsCostPrice(Integer goodsCostPrice) {
        this.goodsCostPrice = goodsCostPrice;
    }
}