package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response;

import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.base.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 团长结算记录RespDto
 * @author 周颠
 * @since 1.0.0
 */
@ApiModel(value = "CommanderSettlementRespDto", description = "团长结算记录RespDto")
public class CommanderSettlementRespDto extends BaseRespDto {
    /**
     * id、extension、tenant_id、instance_id、create_person、create_time、update_person、update_time、dr
     * 以上字段存于父类中
     */

	@ApiModelProperty(name = "commanderId", value = "团长id")
	private Long commanderId;

	@ApiModelProperty(name = "commanderNo", value = "团长编号")
	private String commanderNo;

	@ApiModelProperty(name = "commanderPhone", value = "团长手机号码")
	private String commanderPhone;

	@ApiModelProperty(name = "memberId", value = "下单会员id")
	private Long memberId;

	@ApiModelProperty(name = "memberNo", value = "下单会员编号")
	private String memberNo;

	@ApiModelProperty(name = "memberPhone", value = "下单用户手机")
	private String memberPhone;

	@ApiModelProperty(name = "status", value = "结算状态：0待结算，1可结算，2已结算，3已退款")
	private Integer status;

	@ApiModelProperty(name = "orderTime", value = "下单时间")
	private Date orderTime;

	@ApiModelProperty(name = "orderId", value = "订单id")
	private Long orderId;

	@ApiModelProperty(name = "orderNo", value = "订单编号")
	private String orderNo;

	@ApiModelProperty(name = "orderGoodsId", value = "订单商品id")
	private Long orderGoodsId;

	@ApiModelProperty(name = "goodsNo", value = "商品编号")
	private String goodsNo;

	@ApiModelProperty(name = "goodsName", value = "商品名称")
	private String goodsName;

	@ApiModelProperty(name = "goodsUrl", value = "商品主图片")
	private String goodsUrl;

	@ApiModelProperty(name = "goodsNum", value = "商品数量")
	private Integer goodsNum;

	@ApiModelProperty(name = "goodsPrice", value = "商品销售额（单位：分钱）")
	private Integer goodsPrice;

	@ApiModelProperty(name = "comsType", value = "分佣计算方式：1按比例计算，2按固定值计算")
	private Integer comsType;

	@ApiModelProperty(name = "comsCfg", value = "佣金计算配置值（固定值时，单位：分钱）")
	private Double comsCfg;

	@ApiModelProperty(name = "pointsCfg", value = "积分计算配置值")
	private Double pointsCfg;

	@ApiModelProperty(name = "comsMoney", value = "佣金总额（分成佣金+奖励佣金）")
	private Integer comsMoney;

	@ApiModelProperty(name = "points", value = "总积分（分成积分+奖励积分）")
	private Integer points;

	@ApiModelProperty(name = "comsSource", value = "佣金来源：1直接上级，2间接上级，3自购返佣")
	private Integer comsSource;

	@ApiModelProperty(name = "levelReward", value = "等级奖励比例")
	private Double levelReward;

	@ApiModelProperty(name = "rewardComs", value = "奖励佣金金额（单位：分钱）")
	private Integer rewardComs;

	@ApiModelProperty(name = "rewardPoints", value = "奖励积分")
	private Integer rewardPoints;

	@ApiModelProperty(name = "shareComs", value = "分成佣金金额（单位：分钱）")
	private Integer shareComs;

	@ApiModelProperty(name = "sharePoints", value = "分成积分")
	private Integer sharePoints;

	@ApiModelProperty(name = "refundNum", value = "退款商品数量")
	private Integer refundNum;

	@ApiModelProperty(name = "refundTime", value = "退款时间")
	private Date refundTime;

	@ApiModelProperty(name = "settlTime", value = "由待结算转变为可结算状态的时间（年月日）")
	private Date settlTime;


	public Date getSettlTime() {
		return settlTime;
	}

	public void setSettlTime(Date settlTime) {
		this.settlTime = settlTime;
	}

	public Long getCommanderId(){
		return commanderId;
	}

	public void setCommanderId(Long commanderId){
		this.commanderId = commanderId;
	}

	public String getCommanderNo(){
		return commanderNo;
	}

	public void setCommanderNo(String commanderNo){
		this.commanderNo = commanderNo;
	}

	public String getCommanderPhone(){
		return commanderPhone;
	}

	public void setCommanderPhone(String commanderPhone){
		this.commanderPhone = commanderPhone;
	}

	public Long getMemberId(){
		return memberId;
	}

	public void setMemberId(Long memberId){
		this.memberId = memberId;
	}

	public String getMemberNo(){
		return memberNo;
	}

	public void setMemberNo(String memberNo){
		this.memberNo = memberNo;
	}

	public String getMemberPhone(){
		return memberPhone;
	}

	public void setMemberPhone(String memberPhone){
		this.memberPhone = memberPhone;
	}

	public Integer getStatus(){
		return status;
	}

	public void setStatus(Integer status){
		this.status = status;
	}

	public Date getOrderTime(){
		return orderTime;
	}

	public void setOrderTime(Date orderTime){
		this.orderTime = orderTime;
	}

	public Long getOrderId(){
		return orderId;
	}

	public void setOrderId(Long orderId){
		this.orderId = orderId;
	}

	public String getOrderNo(){
		return orderNo;
	}

	public void setOrderNo(String orderNo){
		this.orderNo = orderNo;
	}

	public Long getOrderGoodsId(){
		return orderGoodsId;
	}

	public void setOrderGoodsId(Long orderGoodsId){
		this.orderGoodsId = orderGoodsId;
	}

	public String getGoodsNo(){
		return goodsNo;
	}

	public void setGoodsNo(String goodsNo){
		this.goodsNo = goodsNo;
	}

	public String getGoodsName(){
		return goodsName;
	}

	public void setGoodsName(String goodsName){
		this.goodsName = goodsName;
	}

	public Integer getGoodsNum(){
		return goodsNum;
	}

	public void setGoodsNum(Integer goodsNum){
		this.goodsNum = goodsNum;
	}

	public Integer getGoodsPrice(){
		return goodsPrice;
	}

	public void setGoodsPrice(Integer goodsPrice){
		this.goodsPrice = goodsPrice;
	}

	public Integer getComsType(){
		return comsType;
	}

	public void setComsType(Integer comsType){
		this.comsType = comsType;
	}

	public Double getComsCfg(){
		return comsCfg;
	}

	public void setComsCfg(Double comsCfg){
		this.comsCfg = comsCfg;
	}

	public Double getPointsCfg(){
		return pointsCfg;
	}

	public void setPointsCfg(Double pointsCfg){
		this.pointsCfg = pointsCfg;
	}

	public Integer getComsMoney(){
		return comsMoney;
	}

	public void setComsMoney(Integer comsMoney){
		this.comsMoney = comsMoney;
	}

	public Integer getPoints(){
		return points;
	}

	public void setPoints(Integer points){
		this.points = points;
	}

	public Integer getComsSource(){
		return comsSource;
	}

	public void setComsSource(Integer comsSource){
		this.comsSource = comsSource;
	}

	public Integer getRefundNum(){
		return refundNum;
	}

	public void setRefundNum(Integer refundNum){
		this.refundNum = refundNum;
	}

	public Date getRefundTime() {
		return refundTime;
	}

	public void setRefundTime(Date refundTime) {
		this.refundTime = refundTime;
	}

	public String getGoodsUrl() {
		return goodsUrl;
	}

	public void setGoodsUrl(String goodsUrl) {
		this.goodsUrl = goodsUrl;
	}

	public Double getLevelReward() {
		return levelReward;
	}

	public void setLevelReward(Double levelReward) {
		this.levelReward = levelReward;
	}

	public Integer getRewardComs() {
		return rewardComs;
	}

	public void setRewardComs(Integer rewardComs) {
		this.rewardComs = rewardComs;
	}

	public Integer getRewardPoints() {
		return rewardPoints;
	}

	public void setRewardPoints(Integer rewardPoints) {
		this.rewardPoints = rewardPoints;
	}

	public Integer getShareComs() {
		return shareComs;
	}

	public void setShareComs(Integer shareComs) {
		this.shareComs = shareComs;
	}

	public Integer getSharePoints() {
		return sharePoints;
	}

	public void setSharePoints(Integer sharePoints) {
		this.sharePoints = sharePoints;
	}
}