package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderCustomerRelationQueryReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderCustomerRelationNewRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderCustomerRelationRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 团长客户关系QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长客户关系"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-query-ICommanderCustomerRelationQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-customer-relation", url = "${bundle.commander.center.member.api:}")
public interface ICommanderCustomerRelationQueryApi {

    /**
     * 根据id查询团长客户关系
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-customer-relation")
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询团长客户关系", notes = "根据id查询团长客户关系")
    RestResponse<CommanderCustomerRelationRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据批量id查询团长客户关系
     * @param ids
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-customer-relation")
    @PostMapping("/batch/query-by-id")
    @ApiOperation(value = "根据批量id查询团长客户关系", notes = "根据批量id查询团长客户关系")
    RestResponse<List<CommanderCustomerRelationRespDto>> queryByIds(@RequestParam("ids") List<Long> ids);

    /**
     * 查询团长客户关系
     * @param queryReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-customer-relation")
    @GetMapping("/query")
    @ApiOperation(value = "查询团长客户关系", notes = "查询团长客户关系")
    RestResponse<List<CommanderCustomerRelationRespDto>> queryCommanderCustomerRelation(@SpringQueryMap CommanderCustomerRelationQueryReqDto queryReqDto);

    /**
     * 分页查询团长客户关系
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-customer-relation")
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询团长客户关系", notes = "分页查询团长客户关系")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<CommanderCustomerRelationNewRespDto> queryCommanderCustomerRelationByPage(@SpringQueryMap CommanderCustomerRelationQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 后管：分页查询团长客户关系
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-customer-relation")
    @GetMapping(value = "/pageVi")
    @ApiOperation(value = "分页查询团长客户关系", notes = "分页查询团长客户关系")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"), @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderCustomerRelationRespDto>> queryCommanderCustomerRelationByPageAdmin(@SpringQueryMap CommanderCustomerRelationQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

}