package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderCycleRecordQueryReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderCycleRecordRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 团长周期数据统计记录QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长周期数据统计记录"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-query-ICommanderCycleRecordQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-cycle-record", url = "${bundle.commander.center.member.api:}")
public interface ICommanderCycleRecordQueryApi {

    /**
     * 根据id查询团长周期数据统计记录
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询团长周期数据统计记录", notes = "根据id查询团长周期数据统计记录")
    RestResponse<CommanderCycleRecordRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据批量id查询团长周期数据统计记录
     * @param ids
     * @return
     */
    @PostMapping("/batch/query-by-id")
    @ApiOperation(value = "根据批量id查询团长周期数据统计记录", notes = "根据批量id查询团长周期数据统计记录")
    RestResponse<List<CommanderCycleRecordRespDto>> queryByIds(@RequestParam("ids") List<Long> ids);

    /**
     * 查询团长周期数据统计记录
     * @param queryReqDto
     * @return
     */
    @GetMapping("/query")
    @ApiOperation(value = "查询团长周期数据统计记录", notes = "查询团长周期数据统计记录")
    RestResponse<List<CommanderCycleRecordRespDto>> queryCommanderCycleRecord(@SpringQueryMap CommanderCycleRecordQueryReqDto queryReqDto);

    /**
     * 分页查询团长周期数据统计记录
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询团长周期数据统计记录", notes = "分页查询团长周期数据统计记录")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderCycleRecordRespDto>> queryCommanderCycleRecordByPage(@SpringQueryMap CommanderCycleRecordQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 根据团长id查询所有周期的最新统计记录
     * @param commanderId
     * @return
     */
    @GetMapping("/query-by-commanderId")
    @ApiOperation(value = "根据团长id查询所有周期的最新统计记录", notes = "根据团长id查询所有周期的最新统计记录")
    RestResponse<List<CommanderCycleRecordRespDto>> queryAllCycleByCommanderId(@RequestParam("commanderId") Long commanderId);
}