package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderLevelDefineQueryReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.AppletLevelInfoRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderLevelDefineRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 团长等级定义QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长等级定义"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-commander-query-ICommanderLevelDefineQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-level-define", url = "${bundle.commander.center.member.api:}")
public interface ICommanderLevelDefineQueryApi {

    /**
     * 根据id查询团长等级定义
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询团长等级定义", notes = "根据id查询团长等级定义")
    RestResponse<CommanderLevelDefineRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据批量id查询团长等级定义
     * @param ids
     * @return
     */
    @PostMapping("/batch/query-by-id")
    @ApiOperation(value = "根据批量id查询团长等级定义", notes = "根据批量id查询团长等级定义")
    RestResponse<List<CommanderLevelDefineRespDto>> queryByIds(@RequestParam("ids") List<Long> ids);

    /**
     * 查询团长等级定义
     * @param queryReqDto
     * @return
     */
    @GetMapping("/query")
    @ApiOperation(value = "查询团长等级定义", notes = "查询团长等级定义")
    RestResponse<List<CommanderLevelDefineRespDto>> queryCommanderLevelDefine(@SpringQueryMap CommanderLevelDefineQueryReqDto queryReqDto);

    /**
     * 分页查询团长等级定义
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询团长等级定义", notes = "分页查询团长等级定义")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderLevelDefineRespDto>> queryCommanderLevelDefineByPage(@SpringQueryMap CommanderLevelDefineQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 小程序查询团长等级信息（C端接口）
     * @param commanderId
     * @return
     */
    @GetMapping("/query-applet-levelInfo/{commanderId}")
    @ApiOperation(value = "小程序查询团长等级信息（C端接口）", notes = "小程序查询团长等级信息（C端接口）")
    RestResponse<AppletLevelInfoRespDto> queryAppletLevelInfo(@PathVariable("commanderId") Long commanderId);
}