package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.request.CommanderPointsDetailsQueryReqDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderPointsDetailsRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.PointsDetailsWithOrderGoodsRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 团长积分明细QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长积分明细"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-query-ICommanderPointsDetailsQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-points-details", url = "${bundle.commander.center.member.api:}")
public interface ICommanderPointsDetailsQueryApi {

    /**
     * 根据id查询团长积分明细
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-points-details")
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询团长积分明细", notes = "根据id查询团长积分明细")
    RestResponse<CommanderPointsDetailsRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据批量id查询团长积分明细
     * @param ids
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-points-details")
    @PostMapping("/batch/query-by-id")
    @ApiOperation(value = "根据批量id查询团长积分明细", notes = "根据批量id查询团长积分明细")
    RestResponse<List<CommanderPointsDetailsRespDto>> queryByIds(@RequestParam("ids") List<Long> ids);

    /**
     * 查询团长积分明细
     * @param queryReqDto
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-points-details")
    @GetMapping("/query")
    @ApiOperation(value = "查询团长积分明细", notes = "查询团长积分明细")
    RestResponse<List<CommanderPointsDetailsRespDto>> queryCommanderPointsDetails(@SpringQueryMap CommanderPointsDetailsQueryReqDto queryReqDto);

    /**
     * 分页查询团长积分明细
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-points-details")
    @GetMapping(value = "/page")
    @ApiOperation(value = "分页查询团长积分明细", notes = "分页查询团长积分明细")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderPointsDetailsRespDto>> queryCommanderPointsDetailsByPage(@SpringQueryMap CommanderPointsDetailsQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 分页查询订单商品类型的团长积分明细（附带商品信息）
     * @param queryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-points-details")
    @GetMapping(value = "/queryWithOrderGoods/page")
    @ApiOperation(value = "分页查询订单商品类型的团长积分明细（附带商品信息）", notes = "分页查询订单商品类型的团长积分明细（附带商品信息）")
    @ApiImplicitParams({@ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<PointsDetailsWithOrderGoodsRespDto>> queryWithOrderGoodsByPage(@SpringQueryMap CommanderPointsDetailsQueryReqDto queryReqDto, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

}