package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderPromoCodeRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 分销员推广码信息表服务接口
 *
 * @author erduo
 * @since 2021-04-13
 */
@Api(tags = {"分销员推广码信息表服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-biz-member-api-commander-query-ICommanderPromoCodeQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-promo-code", url = "${bundle.commander.center.member.api:}")
public interface ICommanderPromoCodeQueryApi {

    /**
     * 根据id查询分销员推广码信息表
     *
     * @param id 分销员推广码信息表id
     * @return 分销员推广码信息表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询分销员推广码信息表", notes = "根据id查询分销员推广码信息表")
    RestResponse<CommanderPromoCodeRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 分销员推广码信息表分页数据
     *
     * @param filter   分销员推广码信息表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分销员推广码信息表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "分销员推广码信息表分页数据", notes = "根据filter查询条件查询分销员推广码信息表数据，filter=CommanderPromoCodeReqDto")
    RestResponse<PageInfo<CommanderPromoCodeRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                  @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
