package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderRelationRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 团长关系QueryApi
 * @author 周颠
 * @since 1.0.0
 */
@Api(tags = {"会员中心：团长关系"})
@FeignClient(contextId="com-dtyunxi-yundt-imkt-cube-bundle-commander-center-member-api-query-ICommanderRelationQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-relation", url = "${bundle.commander.center.member.api:}")
public interface ICommanderRelationQueryApi {

    /**
     * 根据id查询概览信息
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-relation")
    @GetMapping("/overview/{id}")
    @ApiOperation(value = "根据id查询概览信息", notes = "根据id查询概览信息")
    RestResponse<Map<String, Integer>> queryCommanderOverview(@PathVariable("id") Long id);

    /**
     * 根据团长id查询推荐人信息
     * @param id
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-relation")
    @GetMapping("/recommend/{id}")
    @ApiOperation(value = "根据团长id查询推荐人信息", notes = "根据团长id查询推荐人信息")
    RestResponse<List<CommanderRelationRespDto>> queryRecommendCommander(@PathVariable("id") Long id);

    /**
     * 根据团长id分页查询直属团队信息
     * @param id
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-relation")
    @GetMapping("/directlyUnder/{id}")
    @ApiOperation(value = "根据团长id分页查询直属团队信息", notes = "根据团长id分页查询直属团队信息")
    @ApiImplicitParams({@ApiImplicitParam(name = "monthDate", value = "月份起始时间，如：2020-07-01 00:00:00", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "integer", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "integer", paramType = "query"),})
    RestResponse<PageInfo<CommanderRelationRespDto>> queryDirectlyUnderCommander(@PathVariable("id") Long id, @RequestParam(value = "monthDate", required = false) String monthDate, @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize);

    /**
     * 根据团长id查询团长详情信息（团长信息+会员信息+周期统计信息）
     * @param commanderId
     * @return
     */
    @Capability(capabilityCode = "member.commander.commander-relation")
    @GetMapping("/info/{commanderId}")
    @ApiOperation(value = "根据团长id查询团长详情信息（团长信息+会员信息+周期统计信息）", notes = "根据团长id查询团长详情信息（团长信息+会员信息+周期统计信息）")
    RestResponse<CommanderRelationRespDto> queryCommanderInfoDetail(@PathVariable("commanderId") Long commanderId);
}