package com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query;

import com.dtyunxi.annotation.DataLimitCalcFunc;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * 会员函数查询接口
 */
@Api(tags = {"会员中心：会员函数"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-biz-member-api-commander-query-IMemberFunctionQueryApi",
        name = "${bundle.commander.center.member.api.name:yundt-cube-center-member}", path = "/v1/commander-member-function", url = "${bundle.commander.center.member.api:}")
public interface IMemberFunctionQueryApi {

    @DataLimitCalcFunc(beanName = "memberFunctionQuery", funcName = "getMangedOrg", desc = "查询用户直属下级组织（包含本身）")
    @GetMapping("/getMangedOrg")
    @ApiOperation(value = "查询用户直属下级组织（包含本身）", notes = "查询用户直属下级组织（包含本身）")
    RestResponse<List<String>> getMangedOrg();
}
