package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.request.EventUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * @author shenfei
 */
@Api(tags = {"会员中心：事件池接口api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-loyalty-IEventPoolApi", name = "${yundt.cube.center.member.api.name:yundt-cube-center-member}", path = "/v1/eventPool", url = "${yundt.cube.center.member.api:}")
public interface IEventPoolApi {

    @DeleteMapping("{id}")
    @ApiOperation(value = "删除事件", notes = "删除事件")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    @PutMapping
    @ApiOperation(value = "批量更新事件", notes = "批量更新事件")
    RestResponse<Integer> batchUpdate(@RequestBody List<EventUpdateReqDto> dto);

    @PostMapping
    @ApiOperation(value = "新增事件", notes = "新增事件")
    RestResponse<Integer> insert(@RequestBody EventUpdateReqDto dto);

    @PostMapping("addDependCount")
    @ApiOperation(value = "依赖数增减", notes = "依赖数增减")
    RestResponse<Void> addDependCount(@RequestParam("id") Long id, @RequestParam("count") Integer count);
}
