package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.request.EventRuleUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author shenfei
 */
@Api(tags = {"会员中心：事件池规则接口api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-loyalty-IEventRuleApi", name = "${yundt.cube.center.member.api.name:yundt-cube-center-member}", path = "/v1/eventRule", url = "${yundt.cube.center.member.api:}")
public interface IEventRuleApi {

    @DeleteMapping("{id}")
    @ApiOperation(value = "删除规则", notes = "删除规则")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    @PutMapping
    @ApiOperation(value = "批量更新规则", notes = "批量更新规则")
    RestResponse<Integer> batchUpdate(@RequestBody List<EventRuleUpdateReqDto> dto);

    @PostMapping
    @ApiOperation(value = "新增规则", notes = "新增规则")
    RestResponse<Long> insert(@RequestBody EventRuleUpdateReqDto dto);

    @PostMapping("addDependCount")
    @ApiOperation(value = "依赖数增减", notes = "依赖数增减")
    RestResponse<Void> addDependCount(@RequestParam("id") Long id, @RequestParam("count") Integer count);
}
