package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.request.EventTriggerDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author shenfei
 */
@Api(tags = {"会员中心：事件池触发接口api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-loyalty-IEventTriggerApi", name = "${yundt.cube.center.member.api.name:yundt-cube-center-member}", path = "/v1/eventTrigger", url = "${yundt.cube.center.member.api:}")
public interface IEventTriggerApi {

    @PostMapping
    @ApiOperation(value = "触发事件", notes = "触发事件")
    RestResponse<Void> handle(@RequestBody EventTriggerDto dto);

    @PostMapping("calculate")
    @ApiOperation(value = "规则触发次数递增计算", notes = "规则触发次数递增计算")
    RestResponse<Integer> calculate(@RequestBody EventTriggerDto eventTriggerDto);
}
