package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.defaultimpl;

import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.IEventPoolApi;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.IEventRuleApi;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.IEventTriggerApi;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.query.IEventLogQueryApi;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.query.IEventPoolQueryApi;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.query.IEventRuleQueryApi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DefaultImplConfig {

    @Bean
    @ConditionalOnMissingBean
    public IEventLogQueryApi eventLogQueryApi() {
        return new DefaultEventLogQueryApiImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public IEventRuleQueryApi eventRuleQueryApi() {
        return new DefaultEventRuleQueryApiImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public IEventPoolQueryApi eventPoolQueryApi() {
        return new DefaultEventPoolQueryApiImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public IEventTriggerApi eventTriggerApi() {
        return new DefaultEventTriggerApiImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public IEventRuleApi eventRuleApi() {
        return new DefaultEventRuleApiImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public IEventPoolApi eventPoolApi() {
        return new DefaultEventPoolApiImpl();
    }
}
