package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.request;

import com.dtyunxi.yundt.imarketing.dto.es.member.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author 此间
 * @date: 2021/02/01 16:49
 */
@ApiModel(value = "EventLogQueryReqDto", description = "事件池记录列表查询dto")
public class EventLogQueryReqDto extends BaseRespDto {
    /**
     * 会员卡号
     */
    @ApiModelProperty(name = "memberCardNo", value = "会员卡号")
    private String memberCardNo;
    /**
     * 手机号
     */
    @ApiModelProperty(name = "phone", value = "手机号")
    private String phone;
    /**
     * 渠道标识
     */
    @ApiModelProperty(name = "channelId", value = "渠道标识")
    private String channelId;
    /**
     * 事件类型 1:基础, 2：生日, 3:积分，4:卡，5:券，6：标签
     */
    @ApiModelProperty(name = "eventType", value = "事件类型 1:基础, 2：生日, 3:积分，4:卡，5:券，6：标签")
    private Integer eventType;
    /**
     * 事件名称
     */
    @ApiModelProperty(name = "eventName", value = "事件名称")
    private String eventName;
    /**
     * 事件规则名称
     */
    @ApiModelProperty(name = "eventRuleName", value = "事件规则名称")
    private String eventRuleName;

    @ApiModelProperty(name = "pageSize", value = "页数量")
    private Integer pageSize = 10;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum = 1;

    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startTime", value = "开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private Date startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(name = "endTime", value = "结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private Date endTime;

    public String getMemberCardNo() {
        return memberCardNo;
    }

    public void setMemberCardNo(String memberCardNo) {
        this.memberCardNo = memberCardNo;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public Integer getEventType() {
        return eventType;
    }

    public void setEventType(Integer eventType) {
        this.eventType = eventType;
    }

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventRuleName() {
        return eventRuleName;
    }

    public void setEventRuleName(String eventRuleName) {
        this.eventRuleName = eventRuleName;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public String toString() {
        return "EventLogQueryReqDto{" +
                "memberCardNo='" + memberCardNo + '\'' +
                ", phone='" + phone + '\'' +
                ", channelId='" + channelId + '\'' +
                ", eventType=" + eventType +
                ", eventName='" + eventName + '\'' +
                ", eventRuleName='" + eventRuleName + '\'' +
                ", pageSize=" + pageSize +
                ", pageNum=" + pageNum +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                '}';
    }
}
