package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author shenfei
 */
@ApiModel(value = "EventDetailRespDto", description = "事件详情dto")
public class EventDetailRespDto extends BaseRespDto {

    /**
     * 事件id
     */
    @ApiModelProperty(name="id", value = "事件id")
    private Long id;
    /**
     * 事件名称
     */
    @ApiModelProperty(name="name",value = "事件名称")
    private String name;

    /**
     * 事件类型
     */
    @ApiModelProperty(name="eventType",value = "事件类型 1:基础, 2：生日, 3:积分，4:卡，5:券，6：标签")
    private Integer eventType;

    /**
     * 事件编码
     */
    @ApiModelProperty(name="eventCode",value = "事件编码")
    private String eventCode;

    /**
     * 事件状态
     */
    @ApiModelProperty(name="eventStatus",value = "事件状态 1 可用， -1 不可用")
    private Integer eventStatus;

    /**
     * 事件来源
     */
    @ApiModelProperty(name="source",value = "事件来源 1 系统事件， 2 自定义事件")
    private Integer source;

    /**
     * 描述
     */
    @ApiModelProperty(name="description",value = "描述")
    private String description;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getEventType() {
        return eventType;
    }

    public void setEventType(Integer eventType) {
        this.eventType = eventType;
    }

    public String getEventCode() {
        return eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }

    public Integer getEventStatus() {
        return eventStatus;
    }

    public void setEventStatus(Integer eventStatus) {
        this.eventStatus = eventStatus;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
