package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.response;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.enums.EventTriggerModeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.HashMap;
import java.util.Map;

/**
 * @author shenfei
 */
@ApiModel(value = "EventRuleDetailRespDto", description = "事件规则详情dto")
public class EventRuleDetailRespDto extends BaseRespDto {

    /**
     * 事件规则id
     */
    @ApiModelProperty(name="id", value = "事件规则id")
    private Long id;
    /**
     * 事件名称
     */
    @ApiModelProperty(name="name",value = "事件名称")
    private String name;

    /**
     * 事件类型
     */
    @ApiModelProperty(name="eventType",value = "事件类型 1:基础, 2：生日, 3:积分，4:卡，5:券，6：标签")
    private Integer eventType;

    /**
     * 事件名称
     */
    @ApiModelProperty(name="eventName",value = "事件名称")
    private String eventName;

    /**
     * 事件id
     */
    @ApiModelProperty(name="eventId",value = "事件id")
    private Long eventId;

    /**
     * 事件来源
     */
    @ApiModelProperty(name="triggerMode",value = "触发方式 1 单次触发， 2 连续触发 3 累计触发")
    private Integer triggerMode;

    /**
     * 规则类型
     */
    @ApiModelProperty(name="ruleStatus",value = "规则状态 1 可用 2 不可用")
    private Integer ruleStatus;

    /**
     * 描述
     */
    @ApiModelProperty(name="description",value = "描述")
    private String description;

    /**
     * 启用人
     */
    @ApiModelProperty(name="enablePerson",value = "启用人")
    private String enablePerson;

    @ApiModelProperty(name="eventCode",value = "事件码")
    private String eventCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEventCode() {
        return eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getEventType() {
        return eventType;
    }

    public void setEventType(Integer eventType) {
        this.eventType = eventType;
    }

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public Long getEventId() {
        return eventId;
    }

    public void setEventId(Long eventId) {
        this.eventId = eventId;
    }

    public Integer getTriggerMode() {
        return triggerMode;
    }

    public void setTriggerMode(Integer triggerMode) {
        this.triggerMode = triggerMode;
    }

    public Integer getRuleStatus() {
        return ruleStatus;
    }

    public void setRuleStatus(Integer ruleStatus) {
        this.ruleStatus = ruleStatus;
    }

    public String getEnablePerson() {
        return enablePerson;
    }

    public void setEnablePerson(String enablePerson) {
        this.enablePerson = enablePerson;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private static Map<Integer, String> map = new HashMap<>();
    static {
        map.put(1, "天");
        map.put(2, "一");
        map.put(3, "二");
        map.put(4, "三");
        map.put(5, "四");
        map.put(6, "五");
        map.put(7, "六");
    }

    public String getModeDescription() {
        JSONObject extension = JSONObject.parseObject(getExtension());
        if(EventTriggerModeEnum.SINGLE_TRIGGERING.getValue().equals(triggerMode)) {
            return "事件触发时";
        }
        if(EventTriggerModeEnum.SINGLE_TRIGGER_AFTER.getValue().equals(triggerMode)) {
            return "事件触发后" + extension.getString("day") + "天" +
                    fillZero(extension.getString("hour")) + ":" +
                    fillZero(extension.getString("minute")) + ":" +
                    fillZero(extension.getString("second"));
        }
        if(EventTriggerModeEnum.SINGLE_TRIGGER_BEFORE.getValue().equals(triggerMode)) {
            return "事件触发前" + extension.getString("day") + "天" +
                    fillZero(extension.getString("hour")) + ":" +
                    fillZero(extension.getString("minute")) + ":" +
                    fillZero(extension.getString("second"));
        }
        if(EventTriggerModeEnum.CONTINUOUS.getValue().equals(triggerMode)) {
            boolean isWeek = "week".equalsIgnoreCase(extension.getString("period"));
            if(isWeek) {
                return "每周星期" + map.get(extension.getInteger("day")) + "重置";
            } else {
                return "每月" + extension.getInteger("day") + "号重置";
            }
        }
        if(EventTriggerModeEnum.ACCUMULATIVE.getValue().equals(triggerMode)) {
            return "达到" + extension.getInteger("resetTime") + "次重置";
        }
        return "";
    }

    private String fillZero(String value) {
        return value.length() == 1 ? "0" + value : value;
    }

}
