package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.enums;

import java.util.HashSet;
import java.util.Set;

public enum EventTriggerModeEnum {

    /**
     * 单次触发时
     */
    SINGLE_TRIGGERING(1),

    /**
     * 连续天数
     */
    CONTINUOUS(2),

    /**
     * 累计天数
     */
    ACCUMULATIVE(3),

    /**
     * 单次触发前
     */
    SINGLE_TRIGGER_BEFORE(4),

    /**
     * 单次触发后
     */
    SINGLE_TRIGGER_AFTER(5);

    private Integer value;

    EventTriggerModeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static Set<Integer> singleValueSet = new HashSet<>();

    static {
        singleValueSet.add(SINGLE_TRIGGERING.getValue());
        singleValueSet.add(SINGLE_TRIGGER_BEFORE.getValue());
        singleValueSet.add(SINGLE_TRIGGER_AFTER.getValue());

    }
}
