package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.request.EventLogQueryReqDto;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.response.EventLogRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author 此间
 * @date: 2021/02/01 16:52
 */
@Api(tags = {"会员中心：事件池记录api"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-biz-member-api-loyalty-IEventLogQueryApi", name = "${yundt.cube.center.member.api.name:yundt-cube-center-member}", path = "/v1/eventLog", url = "${yundt.cube.center.member.api:}")
public interface IEventLogQueryApi {

    /**
     * 事件池记录分页列表
     *
     * @param eventLogQueryReqDto 请求参数
     * @return
     */
    @PostMapping("/queryByPage")
    @ApiOperation(value = "事件池记录分页列表", notes = "事件池记录分页列表")
    RestResponse<PageInfo<EventLogRespDto>> queryByPage(@RequestBody EventLogQueryReqDto eventLogQueryReqDto);

    @PostMapping("/cleanEventLog")
    @ApiOperation(value = "清理一个月前的记录", notes = "清理前一个月前的记录")
    RestResponse<Void> cleanEventLog();
}
