package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.request.EventQueryReqDto;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.response.EventDetailRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author shenfei
 */
@Api(tags = {"会员中心：事件池查询接口api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-loyalty-IEventPoolQueryApi", name = "${yundt.cube.center.member.api.name:yundt-cube-center-member}", path = "/v1/eventPool", url = "${yundt.cube.center.member.api:}")
public interface IEventPoolQueryApi {

    @GetMapping("{id}")
    @ApiOperation(value = "查询事件详情", notes = "查询事件详情")
    RestResponse<EventDetailRespDto> detail(@PathVariable("id") Long id);

    @GetMapping("code/{code}")
    @ApiOperation(value = "查询事件详情", notes = "查询事件详情")
    RestResponse<EventDetailRespDto> getByCode(@PathVariable("code") String code);

    @GetMapping
    @ApiOperation(value = "查询事件分页", notes = "查询事件分页")
    RestResponse<PageInfo<EventDetailRespDto>> page(@SpringQueryMap EventQueryReqDto dto);

    @GetMapping("list")
    @ApiOperation(value = "类型查询事件列表", notes = "类型查询事件列表")
    RestResponse<List<EventDetailRespDto>> list(@RequestParam("type") Integer type);

    @GetMapping("listAll")
    @ApiOperation(value = "类型查询事件全列表", notes = "类型查询事件全列表")
    RestResponse<List<EventDetailRespDto>> listAll(@RequestParam("type") Integer type);
}
