package com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.request.EventRuleQueryReqDto;
import com.dtyunxi.yundt.imkt.bundle.eventpool.center.member.api.dto.response.EventRuleDetailRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * @author shenfei
 */
@Api(tags = {"会员中心：事件池规则查询接口api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-member-api-loyalty-IEventRuleQueryApi", name = "${yundt.cube.center.member.api.name:yundt-cube-center-member}", path = "/v1/eventRule", url = "${yundt.cube.center.member.api:}")
public interface IEventRuleQueryApi {

    @GetMapping("{id}")
    @ApiOperation(value = "查询规则详情", notes = "查询规则详情")
    RestResponse<EventRuleDetailRespDto> detail(@PathVariable("id") Long id);

    @GetMapping
    @ApiOperation(value = "查询规则分页", notes = "查询规则分页")
    RestResponse<PageInfo<EventRuleDetailRespDto>> page(@SpringQueryMap EventRuleQueryReqDto dto);

    @GetMapping("list")
    @ApiOperation(value = "查询事件列表", notes = "查询事件列表")
    RestResponse<List<EventRuleDetailRespDto>> list(@SpringQueryMap EventRuleQueryReqDto dto);
}
