/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.exception;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.lang.BusinessRuntimeException;

public enum CisStatemachineExceptionCode {
    NORMAL_EXCEPTION("30000", "%s");

    private final String code;
    private final String msg;

    private CisStatemachineExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public BizException buildBizException() {
        return new BizException(this.code, this.msg);
    }

    public static BusinessRuntimeException buildBusinessRuntimeException(Throwable e) {
        return new BusinessRuntimeException("-1", e.getMessage(), e);
    }

    public BizException buildBizException(Object ... formats) {
        String message = String.format(this.msg, formats);
        return new BizException(this.code, message);
    }
}

