/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.utils;

import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisEventMessageHeaderVo;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisActionResult;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisGuardResult;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.statemachine.StateContext;

public class CisActionContextUtils {
    private static final Logger logger = LoggerFactory.getLogger(CisActionContextUtils.class);

    public static <T extends CisEventMessageHeaderVo> T getMessageHeaderVoByContext(StateContext context, Class<T> voClass) {
        return (T)((Object)((CisEventMessageHeaderVo)((Object)context.getMessageHeaders().get((Object)"EVENT_MESSAGE_HEADER_VO_KEY", voClass))));
    }

    public static <T extends CisEventMessageHeaderVo> T getMessageHeaderVoByMessageHeaders(MessageHeaders messageHeaders, Class<T> voClass) {
        return (T)((Object)((CisEventMessageHeaderVo)((Object)messageHeaders.get((Object)"EVENT_MESSAGE_HEADER_VO_KEY", voClass))));
    }

    public static <T extends CisEventMessageHeaderVo> T getMessageHeaderVoByMessageHeaders(MessageHeaders messageHeaders) {
        return (T)((Object)((CisEventMessageHeaderVo)((Object)messageHeaders.get((Object)"EVENT_MESSAGE_HEADER_VO_KEY", CisEventMessageHeaderVo.class))));
    }

    public static <T extends CisEventMessageHeaderVo> T getMessageHeaderVoByMessageHeadersMap(Map<String, Object> messageHeadersMap, Class<T> voClass) {
        return (T)((Object)((CisEventMessageHeaderVo)((Object)messageHeadersMap.get("EVENT_MESSAGE_HEADER_VO_KEY"))));
    }

    public static <S, E> void checkGuardError(StateContext<S, E> context) {
        CisBaseOrderMessageHeaders cisBaseOrderMessageHeaders = CisActionContextUtils.getMessageHeaderVoByContext(context, CisBaseOrderMessageHeaders.class);
        CisActionContextUtils.checkGuardError(cisBaseOrderMessageHeaders);
    }

    public static <S, E> void checkGuardError(CisBaseOrderMessageHeaders cisBaseOrderMessageHeaders) {
        if (cisBaseOrderMessageHeaders == null) {
            throw new RuntimeException("\u72b6\u6001\u673a\u521d\u59cb\u5316\u4e2d");
        }
        Optional.ofNullable(cisBaseOrderMessageHeaders.getAllGuardResultList()).ifPresent(resultList -> resultList.forEach(row -> {
            CisActionResult cisActionResult = (CisActionResult)((Object)((Object)((Object)row)));
            Throwable throwable = ((CisGuardResult)((Object)((Object)((Object)cisActionResult.getResultData())))).getGuardThrowable();
            if (throwable != null) {
                logger.error(throwable.getMessage(), throwable);
                throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException("\u5b88\u536b\u6267\u884c\u5f02\u5e38\uff1a" + throwable.getMessage());
            }
            throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(((CisGuardResult)((Object)((Object)((Object)cisActionResult.getResultData())))).getGuardFalseMessage());
        }));
    }
}

