/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.utils;

import com.dtyunxi.app.ServiceContext;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CompletableFutureUtils {
    private static final Logger logger = LoggerFactory.getLogger(CompletableFutureUtils.class);

    public static CompletableFuture<Void> runAsync(Consumer consumer) {
        String reqId = ServiceContext.getContext().getRequestId();
        Map objs = ServiceContext.getContext().getAttachments();
        return CompletableFuture.runAsync(() -> {
            try {
                MDC.put((String)"yes.req.requestId", (String)reqId);
                ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                if (objs != null) {
                    objs.forEach((key, value) -> ServiceContext.getContext().setAttachment(key, value));
                }
                consumer.accept(null);
            }
            finally {
                MDC.remove((String)"yes.req.requestId");
                ServiceContext.getContext().removeAttachment("yes.req.requestId");
                ServiceContext.getContext().removeAttachmentContext();
            }
        });
    }
}

