/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum CisActionResultType {
    SUCCESS("SUCCESS", "\u6267\u884c\u6210\u529f"),
    FAIL("FAIL", "\u6267\u884c\u5931\u8d25"),
    ERROR("ERROR", "\u6267\u884c\u5f02\u5e38");

    private final String code;
    private final String desc;
    public static final Map<String, CisActionResultType> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private CisActionResultType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CisActionResultType forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(CisActionResultType.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(CisActionResultType.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

