/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum EventExecuteListenerType {
    AFTER_REGISTER("AFTER_REGISTER", "\u4e8b\u4ef6\u6ce8\u518c\u5b8c\u6210\u540e"),
    PRE_EXECUTE("PRE_EXECUTE", "\u4e8b\u4ef6\u6267\u884c\u524d"),
    END_EXECUTE("END_EXECUTE", "\u4e8b\u4ef6\u6267\u884c\u540e");

    private final String code;
    private final String desc;
    public static final Map<String, EventExecuteListenerType> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private EventExecuteListenerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EventExecuteListenerType forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(EventExecuteListenerType.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(EventExecuteListenerType.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

