/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum EventRecordExecuteStatusEnum {
    REGISTER(-1, "\u5df2\u6ce8\u518c"),
    PRE_EXE(0, "\u51c6\u5907\u6267\u884c"),
    EXE_SUCCESS(1, "\u6267\u884c\u6210\u529f"),
    EXE_FAIL(2, "\u6267\u884c\u5931\u8d25"),
    EXE_ERROR(3, "\u6267\u884c\u5f02\u5e38");

    private final Integer code;
    private final String desc;
    public static final Map<Integer, EventRecordExecuteStatusEnum> CODE_LOOKUP;
    public static final Map<Integer, String> CODE_DESC_MAP;

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private EventRecordExecuteStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EventRecordExecuteStatusEnum forCode(Integer code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<Integer, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    static {
        CODE_LOOKUP = Arrays.stream(EventRecordExecuteStatusEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(EventRecordExecuteStatusEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

