/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.vo.header;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.statemachine.engine.enums.CisActionResultType;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseRequest;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisEventMessageHeaderVo;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisActionResult;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisGuardResult;
import com.dtyunxi.rest.RestResponse;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class CisBaseOrderMessageHeaders<AC extends CisActionDefine, S, E, RQ, DTO extends ThroughDtoDefine>
extends CisEventMessageHeaderVo<CisBaseRequest<RQ>, AC, E> {
    private final DTO throughDto;

    public CisBaseOrderMessageHeaders(DTO throughDto, RQ request, E events) {
        super(new CisBaseRequest<RQ>(request), events);
        this.throughDto = throughDto;
    }

    public DTO getThroughDto() {
        return this.throughDto;
    }

    @Override
    public <RS> CisActionResult<AC, RS> addSuccessResult(String bizCode, AC action, RS result) {
        return super.addSuccessResult(bizCode, action, result);
    }

    public CisActionResult<AC, CisGuardResult> addGuardResult(String bizCode, AC action, CisGuardResult result) {
        return super.addGuardResult(bizCode, action, result, null);
    }

    @Override
    public CisActionResult<AC, CisGuardResult> addGuardResult(String bizCode, AC action, CisGuardResult result, Throwable throwable) {
        return super.addGuardResult(bizCode, action, result, throwable);
    }

    @Override
    public CisActionResult<AC, CisGuardResult> addGuardResult2ExeResult(String bizCode, AC action, CisGuardResult result, Throwable throwable) {
        return super.addGuardResult2ExeResult(bizCode, action, result, throwable);
    }

    @Override
    public <RS> CisActionResult<AC, RS> addFailResult(String bizCode, AC action, RS result) {
        return super.addFailResult(bizCode, action, result);
    }

    public CisActionResult<AC, ?> addErrorResultSub(String bizCode, AC action, Throwable throwable) {
        return super.addErrorResult(bizCode, action, throwable);
    }

    public <RS> RS getLastActionResultSub(Class<RS> rsClass) {
        return (RS)Optional.ofNullable(super.getLastActionResult()).map(CisActionResult::getResultData).orElseGet(() -> null);
    }

    public CisActionResult<AC, ?> getLastActionResultSub() {
        return Optional.ofNullable(super.getLastActionResult()).orElseGet(() -> null);
    }

    public CisActionResult<AC, CisGuardResult> getLastGuardResultSub() {
        return CollectionUtils.isEmpty(this.getAllGuardResultList()) ? null : this.getAllGuardResultList().get(this.getAllGuardResultList().size() - 1);
    }

    public <RS> RestResponse<RS> getLastActionResultSubRestResponse(Class<RS> rsClass) {
        return Optional.ofNullable(super.getLastActionResult()).map(rs -> this.exchangeRestResponse((CisActionResult<AC, ?>)((Object)rs), rsClass)).orElseGet(() -> null);
    }

    public <RS> RS getFirstActionResultSub(Class<RS> rsClass) {
        return (RS)Optional.ofNullable(super.getFirstActionResult()).map(CisActionResult::getResultData).orElseGet(() -> null);
    }

    public CisActionResult<AC, ?> getFirstActionResultSub() {
        return Optional.ofNullable(super.getLastActionResult()).orElseGet(() -> null);
    }

    public <RS> RestResponse<RS> getFirstActionResultSubRestResponse(Class<RS> rsClass) {
        return Optional.ofNullable(super.getFirstActionResult()).map(rs -> this.exchangeRestResponse((CisActionResult<AC, ?>)((Object)rs), rsClass)).orElseGet(() -> null);
    }

    public <RS> RestResponse<RS> getActionResultSubRestResponse(Class<RS> rsClass) {
        return Optional.ofNullable(this.chooseResult()).map(rs -> this.exchangeRestResponse((CisActionResult<AC, ?>)((Object)rs), rsClass)).orElseGet(() -> null);
    }

    public void checkStatemachineExecuteResult() {
        Optional.ofNullable(this.chooseResult()).ifPresent(this::checkResponse);
    }

    public CisActionResult<AC, ?> chooseResult() {
        for (CisActionResult cisActionResult : super.getAllActionResultList()) {
            if (!Objects.equals((Object)cisActionResult.getActionResultType(), (Object)CisActionResultType.ERROR) && !Objects.equals((Object)cisActionResult.getActionResultType(), (Object)CisActionResultType.FAIL)) continue;
            return cisActionResult;
        }
        for (CisActionResult cisActionResult : super.getAllGuardResultList()) {
            if (!Objects.equals((Object)cisActionResult.getActionResultType(), (Object)CisActionResultType.ERROR) && !Objects.equals((Object)cisActionResult.getActionResultType(), (Object)CisActionResultType.FAIL)) continue;
            return cisActionResult;
        }
        return this.getFirstActionResult();
    }

    public void checkResponse(CisActionResult<AC, ?> cisActionResult) {
        if (Objects.equals((Object)cisActionResult.getActionResultType(), (Object)CisActionResultType.ERROR)) {
            if (cisActionResult.getThrowable() instanceof BizException) {
                throw new BizException(((BizException)cisActionResult.getThrowable()).getCode(), Optional.ofNullable(cisActionResult.getAction()).map(CisActionDefine::getDesc).orElseGet(() -> "") + "-\u5931\u8d25:" + cisActionResult.getThrowable().getMessage());
            }
            if (cisActionResult.getThrowable() != null) {
                throw new RuntimeException(Optional.ofNullable(cisActionResult.getAction()).map(CisActionDefine::getDesc).orElseGet(() -> "") + "-\u5931\u8d25:" + cisActionResult.getThrowable().getMessage(), cisActionResult.getThrowable());
            }
            throw new RuntimeException(Optional.ofNullable(cisActionResult.getAction()).map(CisActionDefine::getDesc).orElseGet(() -> "") + "-\u5931\u8d25");
        }
        if (Objects.equals((Object)cisActionResult.getActionResultType(), (Object)CisActionResultType.FAIL)) {
            if (cisActionResult.getResultData() instanceof CisGuardResult) {
                throw new BizException(((CisGuardResult)((Object)cisActionResult.getResultData())).getGuardResultCode(), ((CisGuardResult)((Object)cisActionResult.getResultData())).getGuardFalseMessage());
            }
            throw new RuntimeException(Optional.ofNullable(cisActionResult.getAction()).map(CisActionDefine::getDesc).orElseGet(() -> "") + "-\u5931\u8d25:" + cisActionResult.getThrowable().getMessage(), cisActionResult.getThrowable());
        }
    }

    public <RS> RestResponse<RS> exchangeRestResponse(CisActionResult<AC, ?> cisActionResult, Class<RS> rsClass) {
        if (Objects.equals((Object)cisActionResult.getActionResultType(), (Object)CisActionResultType.ERROR)) {
            if (cisActionResult.getThrowable() instanceof BizException) {
                return new RestResponse(((BizException)cisActionResult.getThrowable()).getCode(), Optional.ofNullable(cisActionResult.getAction()).map(CisActionDefine::getDesc).orElseGet(() -> "") + "-\u5931\u8d25:" + cisActionResult.getThrowable().getMessage());
            }
            if (cisActionResult.getThrowable() != null) {
                throw new RuntimeException(Optional.ofNullable(cisActionResult.getAction()).map(CisActionDefine::getDesc).orElseGet(() -> "") + "-\u5931\u8d25:" + cisActionResult.getThrowable().getMessage(), cisActionResult.getThrowable());
            }
            throw new RuntimeException(Optional.ofNullable(cisActionResult.getAction()).map(CisActionDefine::getDesc).orElseGet(() -> "") + "-\u5931\u8d25");
        }
        if (Objects.equals((Object)cisActionResult.getActionResultType(), (Object)CisActionResultType.FAIL)) {
            if (cisActionResult.getResultData() instanceof CisGuardResult) {
                return new RestResponse(((CisGuardResult)((Object)cisActionResult.getResultData())).getGuardResultCode(), ((CisGuardResult)((Object)cisActionResult.getResultData())).getGuardFalseMessage());
            }
            throw new RuntimeException(Optional.ofNullable(cisActionResult.getAction()).map(CisActionDefine::getDesc).orElseGet(() -> "") + "-\u5931\u8d25:" + cisActionResult.getThrowable().getMessage(), cisActionResult.getThrowable());
        }
        return (RestResponse)cisActionResult.getResultData();
    }
}

