/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.vo.header;

import com.dtyunxi.cube.statemachine.engine.enums.CisActionResultType;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisActionResult;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisGuardResult;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisRegisterEvent;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CisEventMessageHeaderVo<RQ, AC, E>
extends BaseVo {
    private final E event;
    private final RQ request;
    private final Map<String, Object> bizHeaders;
    private final List<CisRegisterEvent> registerEventList = new LinkedList<CisRegisterEvent>();
    private final List<CisActionResult<AC, ?>> allActionResultList = new LinkedList();
    private final List<CisActionResult<AC, CisGuardResult>> allGuardResultList = new LinkedList<CisActionResult<AC, CisGuardResult>>();
    private final Map<String, Map<AC, List<CisActionResult<AC, ?>>>> allResultMap = new TreeMap();
    private final List<Object> allExeResultList = new LinkedList<Object>();
    private final String messageId;
    private static final String DEFAULT_BIZ_CODE = "DEFAULT_BIZ_CODE";

    public CisEventMessageHeaderVo(RQ request, E event) {
        this.request = request;
        this.event = event;
        this.messageId = String.valueOf(IdGenrator.nextId((long)0L, (long)0L));
        this.bizHeaders = new HashMap<String, Object>();
    }

    protected <RS> CisActionResult<AC, RS> addSuccessResult(String bizCode, @NotNull AC action, RS result) {
        CisActionResult<AC, RS> actionResult = new CisActionResult<AC, RS>(action, StringUtils.isNotBlank((CharSequence)bizCode) ? bizCode : DEFAULT_BIZ_CODE, result, CisActionResultType.SUCCESS);
        this.allActionResultList.add(actionResult);
        this.allExeResultList.add(actionResult);
        this.pushActionResult(actionResult);
        return actionResult;
    }

    protected <RS> CisActionResult<AC, RS> addFailResult(String bizCode, @NotNull AC action, RS result) {
        CisActionResult<AC, RS> actionResult = new CisActionResult<AC, RS>(action, StringUtils.isNotBlank((CharSequence)bizCode) ? bizCode : DEFAULT_BIZ_CODE, result, CisActionResultType.FAIL);
        this.allActionResultList.add(actionResult);
        this.allExeResultList.add(actionResult);
        this.pushActionResult(actionResult);
        return actionResult;
    }

    protected <RS> CisActionResult<AC, RS> addErrorResult(String bizCode, @NotNull AC action, Throwable throwable) {
        CisActionResult actionResult = new CisActionResult(action, StringUtils.isNotBlank((CharSequence)bizCode) ? bizCode : DEFAULT_BIZ_CODE, throwable, CisActionResultType.ERROR);
        this.allActionResultList.add(actionResult);
        this.allExeResultList.add((Object)actionResult);
        this.pushActionResult(actionResult);
        return actionResult;
    }

    protected CisActionResult<AC, CisGuardResult> addGuardResult(String bizCode, @NotNull AC action, CisGuardResult result, Throwable throwable) {
        CisActionResult<AC, CisGuardResult> actionResult = new CisActionResult<AC, CisGuardResult>(action, result.getGuardId(), StringUtils.isNotBlank((CharSequence)bizCode) ? bizCode : DEFAULT_BIZ_CODE, result, throwable, throwable == null ? CisActionResultType.FAIL : CisActionResultType.ERROR);
        this.allGuardResultList.add(actionResult);
        return actionResult;
    }

    protected CisActionResult<AC, CisGuardResult> addGuardResult2ExeResult(String bizCode, AC action, CisGuardResult result, Throwable throwable) {
        CisActionResult<AC, CisGuardResult> actionResult = new CisActionResult<AC, CisGuardResult>(action, result.getGuardId(), StringUtils.isNotBlank((CharSequence)bizCode) ? bizCode : DEFAULT_BIZ_CODE, result, throwable, throwable == null ? CisActionResultType.FAIL : CisActionResultType.ERROR);
        this.allExeResultList.add(actionResult);
        return actionResult;
    }

    protected <RS> void pushActionResult(CisActionResult<AC, RS> actionResult) {
        Optional.ofNullable(Optional.ofNullable(this.allResultMap.get(actionResult.getBizCode())).orElseGet(() -> {
            TreeMap acListHashMap = new TreeMap();
            this.allResultMap.put(actionResult.getBizCode(), acListHashMap);
            return acListHashMap;
        }).get(actionResult.getAction())).orElseGet(() -> {
            LinkedList cisActionResultList = new LinkedList();
            this.allResultMap.get(actionResult.getBizCode()).put(actionResult.getAction(), cisActionResultList);
            return cisActionResultList;
        }).add(actionResult);
    }

    protected <RS> CisActionResult<AC, RS> getLastActionResult() {
        return CollectionUtils.isEmpty(this.allActionResultList) ? null : this.allActionResultList.get(this.allActionResultList.size() - 1);
    }

    protected <RS> CisActionResult<AC, RS> getFirstActionResult() {
        return CollectionUtils.isEmpty(this.allActionResultList) ? null : this.allActionResultList.get(0);
    }

    public <RS> CisActionResult<AC, RS> getFirstActionResult(AC action) {
        return Optional.ofNullable(this.allActionResultList).map(list -> list.stream().filter(actionResult -> actionResult.getAction().equals(action)).findFirst().orElse(null)).orElse(null);
    }

    public RQ getRequest() {
        return this.request;
    }

    public Map<String, Map<AC, List<CisActionResult<AC, ?>>>> getAllResultMap() {
        return this.allResultMap;
    }

    public List<CisActionResult<AC, ?>> getDefaultActionResult(AC action) {
        return Optional.ofNullable(this.allResultMap.get(DEFAULT_BIZ_CODE)).map(map -> (List)map.get(action)).orElseGet(() -> null);
    }

    public List<CisActionResult<AC, ?>> getAllActionResultList() {
        return this.allActionResultList;
    }

    public List<Object> getAllExeResultList() {
        return this.allExeResultList;
    }

    public List<CisActionResult<AC, ?>> chooseActionResultList(Predicate<CisActionResult<AC, ?>> predicate) {
        return this.allActionResultList.stream().filter(predicate).collect(Collectors.toList());
    }

    public List<CisActionResult<AC, CisGuardResult>> getAllGuardResultList() {
        return this.allGuardResultList;
    }

    public List<CisActionResult<AC, CisGuardResult>> chooseGuardResultList(Predicate<CisActionResult<AC, CisGuardResult>> predicate) {
        return this.allGuardResultList.stream().filter(predicate).collect(Collectors.toList());
    }

    public E getEvent() {
        return this.event;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Object putBizHeader(String key, Object value) {
        return this.bizHeaders.put(key, value);
    }

    public Object getBizHeader(String key) {
        return this.bizHeaders.get(key);
    }

    public <T> T getBizHeaderByClass(String key, Class<T> cls) {
        return (T)this.bizHeaders.get(key);
    }

    public Map<String, Object> getHeaderMap() {
        return this.bizHeaders;
    }

    public List<CisRegisterEvent> getRegisterEventList() {
        return this.registerEventList;
    }
}

