/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.action;

import com.dtyunxi.cube.statemachine.engine.action.AbstractCisStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.transaction.CisTransactionManagerUtils;
import com.dtyunxi.cube.statemachine.engine.utils.CisActionContextUtils;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseRequest;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisActionResult;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ParamConverter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;

public abstract class AbstractCisBaseStatemachineAction<AC extends CisActionDefine, S, E, RQ, RS, DTO extends ThroughDtoDefine>
extends AbstractCisStatemachineAction<S, E, CisBaseOrderMessageHeaders<AC, S, E, RQ, DTO>> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCisBaseStatemachineAction.class);
    private final AC actionDefineEnum;
    private final boolean needTransactionBefore;

    public AbstractCisBaseStatemachineAction(AC actionDefineEnum) {
        this.actionDefineEnum = actionDefineEnum;
        this.needTransactionBefore = false;
    }

    public AbstractCisBaseStatemachineAction(AC actionDefineEnum, boolean needTransaction) {
        this.actionDefineEnum = actionDefineEnum;
        this.needTransactionBefore = needTransaction;
    }

    public AC getActionDefineEnum() {
        return this.actionDefineEnum;
    }

    @Override
    public void executeSub(StateContext<S, E> context) {
        logger.info("StatemachineLogTrack cisStatemachineAction pre execute " + this.actionDefineEnum);
        Throwable throwable = null;
        try {
            CisBaseOrderMessageHeaders cisBaseOrderMessageHeaders = (CisBaseOrderMessageHeaders)CisActionContextUtils.getMessageHeaderVoByContext(context, CisBaseOrderMessageHeaders.class);
            ThroughDtoDefine throughDto = cisBaseOrderMessageHeaders.getThroughDto();
            logger.info("StatemachineLogTrack cisStatemachineAction execute {} {}", (Object)throughDto.getId(), this.actionDefineEnum);
            CisActionContextUtils.checkGuardError((CisBaseOrderMessageHeaders)cisBaseOrderMessageHeaders);
            if (this.needTransactionBefore) {
                CisTransactionManagerUtils.actionTransactionBefore();
            }
            RS result = this.executeSubByHeaderMessages(throughDto, this.exchangeRequestException(cisBaseOrderMessageHeaders), cisBaseOrderMessageHeaders);
            cisBaseOrderMessageHeaders.addSuccessResult(ParamConverter.convertToString((Object)throughDto.getId()), this.actionDefineEnum, result);
            logger.info("StatemachineLogTrack cisStatemachineAction execute {} {} end", (Object)throughDto.getId(), this.actionDefineEnum);
        }
        catch (Throwable e) {
            throwable = e;
            logger.error("StatemachineLogTrack cisStatemachineAction error execute " + this.actionDefineEnum + " : " + e.getMessage(), e);
            CisTransactionManagerUtils.actionTransactionRollback(this.needTransactionBefore);
            CisBaseOrderMessageHeaders cisBaseOrderMessageHeaders = (CisBaseOrderMessageHeaders)CisActionContextUtils.getMessageHeaderVoByContext(context, CisBaseOrderMessageHeaders.class);
            ThroughDtoDefine throughDto = cisBaseOrderMessageHeaders.getThroughDto();
            cisBaseOrderMessageHeaders.addErrorResultSub(String.valueOf(Optional.ofNullable(throughDto).map(ThroughDtoDefine::getId)), this.actionDefineEnum, e);
            throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u6267\u884c\u5f02\u5e38:" + e.getMessage()});
        }
        finally {
            if (throwable == null) {
                logger.info("StatemachineLogTrack cisStatemachineAction end execute " + this.actionDefineEnum);
            }
        }
    }

    private <RS> boolean checkRsSuccess(RS result) {
        if (result == null) {
            return true;
        }
        if (result instanceof RestResponse) {
            return RestResponse.TRUE.getResultCode().equals(((RestResponse)result).getResultCode());
        }
        return false;
    }

    public RQ exchangeRequestException(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders) {
        try {
            return this.exchangeRequest(cisBaseOrderMessageHeaders);
        }
        catch (Exception e) {
            logger.error(this.getActionDefineEnum() + "-action request\u672a\u8f6c\u6362\u6210\u529f\uff1a" + e.getMessage());
            throw e;
        }
    }

    public RQ exchangeRequest(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders) {
        return (RQ)Optional.ofNullable(cisBaseOrderMessageHeaders.getLastActionResultSub()).map(rs -> this.exchangeRequest(cisBaseOrderMessageHeaders, (CisActionResult<AC, ?>)rs)).orElseGet(() -> this.exchangeRequest(cisBaseOrderMessageHeaders, null));
    }

    public RQ exchangeRequestDefault(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders, CisActionResult<AC, ?> lastCisActionResult) {
        return this.exchangeRequest(cisBaseOrderMessageHeaders, lastCisActionResult);
    }

    public RQ exchangeRequest(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders, CisActionResult<AC, ?> lastCisActionResult) {
        return this.defaultExchange(cisBaseOrderMessageHeaders, lastCisActionResult);
    }

    protected RQ defaultExchange(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders, CisActionResult<AC, ?> lastCisActionResult) {
        try {
            return (RQ)((CisBaseRequest)cisBaseOrderMessageHeaders.getRequest()).getRequestData();
        }
        catch (Exception e) {
            logger.error("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{this.getActionDefineEnum() + "\u672a\u914d\u7f6erequest\u8f6c\u6362\u5230" + lastCisActionResult.getAction()});
        }
    }

    public abstract RS executeSub(DTO var1, RQ var2);

    public RS executeSubByHeaderMessages(DTO throughDtoDefine, RQ request, CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders) {
        return this.executeSub(throughDtoDefine, request);
    }
}

