/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.statemachine.engine.action.AbstractCisStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.statemachine.engine.enums.RegisterEventExecuteType;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.execute.CisStatemachineExecutor;
import com.dtyunxi.cube.statemachine.engine.listener.StatemachineEventExecuteListener;
import com.dtyunxi.cube.statemachine.engine.transaction.CisTransactionManagerUtils;
import com.dtyunxi.cube.statemachine.engine.utils.CisActionContextUtils;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseRequest;
import com.dtyunxi.cube.statemachine.engine.vo.listener.EventExecuteListenerVo;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisActionResult;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisRegisterEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;

public abstract class AbstractCisRegisterEventStatemachineAction<AC extends CisActionDefine, S, E, RQ, RS, DTO extends ThroughDtoDefine>
extends AbstractCisStatemachineAction<S, E, CisBaseOrderMessageHeaders<AC, S, E, RQ, DTO>> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCisRegisterEventStatemachineAction.class);
    private CisStatemachineExecutor<?, ?> cisStatemachineExecutor;
    private final RegisterEventExecuteType registerEventType;
    private boolean addFirst = false;
    private final List<Object> registerEventList = new ArrayList<Object>();

    @SafeVarargs
    public AbstractCisRegisterEventStatemachineAction(E ... registerEvents) {
        if (registerEvents != null) {
            this.registerEventList.addAll(Arrays.asList(registerEvents));
        }
        this.registerEventType = null;
    }

    public AbstractCisRegisterEventStatemachineAction(boolean addFirst) {
        this.addFirst = addFirst;
        this.registerEventType = null;
    }

    public AbstractCisRegisterEventStatemachineAction(CisStatemachineExecutor<?, ?> cisStatemachineExecutor, Object ... registerEvents) {
        if (registerEvents != null) {
            this.registerEventList.addAll(Arrays.asList(registerEvents));
        }
        this.cisStatemachineExecutor = cisStatemachineExecutor;
        this.registerEventType = null;
    }

    public AbstractCisRegisterEventStatemachineAction(CisStatemachineExecutor<?, ?> cisStatemachineExecutor, RegisterEventExecuteType registerEventType, Object ... registerEvents) {
        if (registerEvents != null) {
            this.registerEventList.addAll(Arrays.asList(registerEvents));
        }
        this.cisStatemachineExecutor = cisStatemachineExecutor;
        this.registerEventType = registerEventType;
    }

    @Override
    public final void executeSub(StateContext<S, E> context) {
        logger.info("StatemachineLogTrack registerEvent Action " + JSON.toJSONString(this.registerEventList));
        try {
            CisBaseOrderMessageHeaders cisBaseOrderMessageHeaders = (CisBaseOrderMessageHeaders)CisActionContextUtils.getMessageHeaderVoByContext(context, CisBaseOrderMessageHeaders.class);
            ThroughDtoDefine throughDto = cisBaseOrderMessageHeaders.getThroughDto();
            if (!this.registerEventList.isEmpty()) {
                this.registerEventList.stream().map(event -> new CisRegisterEvent(event, this.exchangeRequestException(cisBaseOrderMessageHeaders), this.exchangeEventThoughDtoId(throughDto, cisBaseOrderMessageHeaders), this.cisStatemachineExecutor)).forEach(registerEvent -> {
                    if (this.addFirst) {
                        cisBaseOrderMessageHeaders.getRegisterEventList().add(0, registerEvent);
                    } else {
                        cisBaseOrderMessageHeaders.getRegisterEventList().add(registerEvent);
                    }
                    this.afterRegisterEvent(this.cisStatemachineExecutor.getStatemachineEventExecuteListener(), (CisRegisterEvent)registerEvent, this.cisStatemachineExecutor);
                });
            } else {
                Optional.ofNullable(this.exchangeRegisterEvent(cisBaseOrderMessageHeaders)).ifPresent(list -> {
                    if (this.addFirst) {
                        cisBaseOrderMessageHeaders.getRegisterEventList().addAll(0, list);
                    } else {
                        cisBaseOrderMessageHeaders.getRegisterEventList().addAll(list);
                    }
                    list.forEach(registerEvent -> this.afterRegisterEvent(null, (CisRegisterEvent)registerEvent, (CisStatemachineExecutor<?, ?>)((CisStatemachineExecutor)cisBaseOrderMessageHeaders.getBizHeader("EVENT_MESSAGE_HEADER_VO_BIZ_MAP_KEY_STATE_MACHINE_EXECUTOR"))));
                });
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            CisTransactionManagerUtils.actionTransactionRollback();
            throw e;
        }
        finally {
            logger.info("StatemachineLogTrack end registerEvent Action " + JSON.toJSONString(this.registerEventList));
        }
    }

    private void afterRegisterEvent(StatemachineEventExecuteListener statemachineEventExecuteListener, CisRegisterEvent cisRegisterEvent, CisStatemachineExecutor<?, ?> statemachineExecutor) {
        statemachineEventExecuteListener = Optional.ofNullable(statemachineEventExecuteListener).orElseGet(() -> statemachineExecutor.getStatemachineEventExecuteListener());
        Optional.ofNullable(statemachineEventExecuteListener).ifPresent(listener -> listener.afterEventRegister(EventExecuteListenerVo.builder().cisRegisterEvent(cisRegisterEvent).build()));
    }

    public RQ exchangeRequestException(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders) {
        try {
            return this.exchangeRequest(cisBaseOrderMessageHeaders);
        }
        catch (Exception e) {
            logger.error(this.getClass() + "-action request\u672a\u8f6c\u6362\u6210\u529f\uff1a" + e.getMessage());
            throw e;
        }
    }

    public List<CisRegisterEvent> exchangeRegisterEvent(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders) {
        return Optional.ofNullable(cisBaseOrderMessageHeaders.getLastActionResultSub()).map(rs -> this.exchangeRegisterEventList(cisBaseOrderMessageHeaders, (CisActionResult<AC, ?>)rs)).orElseGet(() -> this.exchangeRegisterEventList(cisBaseOrderMessageHeaders, null));
    }

    public List<CisRegisterEvent> exchangeRegisterEventList(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders, CisActionResult<AC, ?> lastCisActionResult) {
        Object request = this.exchangeRequestException(cisBaseOrderMessageHeaders);
        Long thoughDtoId = this.exchangeEventThoughDtoId(cisBaseOrderMessageHeaders.getThroughDto(), cisBaseOrderMessageHeaders);
        return this.registerEventList.stream().map(registerEvent -> new CisRegisterEvent(registerEvent, request, thoughDtoId, null)).collect(Collectors.toList());
    }

    public RQ exchangeRequest(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders) {
        return (RQ)Optional.ofNullable(cisBaseOrderMessageHeaders.getLastActionResultSub()).map(rs -> this.exchangeRequest(cisBaseOrderMessageHeaders, (CisActionResult<AC, ?>)rs)).orElseGet(() -> ((CisBaseRequest)cisBaseOrderMessageHeaders.getRequest()).getRequestData());
    }

    public RQ exchangeRequestDefault(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders, CisActionResult<AC, ?> lastCisActionResult) {
        return this.exchangeRequest(cisBaseOrderMessageHeaders, lastCisActionResult);
    }

    public RQ exchangeRequest(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders, CisActionResult<AC, ?> lastCisActionResult) {
        return this.defaultExchange(cisBaseOrderMessageHeaders, lastCisActionResult);
    }

    protected RQ defaultExchange(CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders, CisActionResult<AC, ?> lastCisActionResult) {
        try {
            return (RQ)((CisBaseRequest)cisBaseOrderMessageHeaders.getRequest()).getRequestData();
        }
        catch (Exception e) {
            logger.error("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u672a\u914d\u7f6erequest\u8f6c\u6362\u5230" + lastCisActionResult.getAction()});
        }
    }

    public Long exchangeEventThoughDtoId(DTO throughDtoDefine, CisBaseOrderMessageHeaders<AC, S, E, ?, DTO> cisBaseOrderMessageHeaders) {
        return throughDtoDefine.getId();
    }

    public void setAddFirst(boolean addFirst) {
        this.addFirst = addFirst;
    }

    public boolean isAddFirst() {
        return this.addFirst;
    }
}

