/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.action;

import com.dtyunxi.cube.statemachine.engine.action.ActionAround;
import com.dtyunxi.cube.statemachine.engine.action.CisNextAction;
import com.dtyunxi.cube.statemachine.engine.action.DefaultCisErrorCatchAction;
import com.dtyunxi.cube.statemachine.engine.action.DefaultCisNextAction;
import com.dtyunxi.cube.statemachine.engine.utils.CisActionContextUtils;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisEventMessageHeaderVo;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.guard.Guard;

public abstract class AbstractCisStatemachineAction<S, E, T extends CisEventMessageHeaderVo>
implements Action<S, E> {
    private static final ActionAround DEFAULT_AROUND = (ac, o) -> o.accept(null);

    public final void execute(StateContext<S, E> context) {
        CisActionContextUtils.checkGuardError(context);
        Consumer<Object> consumer = o -> this.executeSub(context);
        Optional.ofNullable(context.getMessageHeader((Object)"MESSAGE_HEADER_ACTION_AROUND_KEY")).map(o -> (ActionAround)o).orElse(DEFAULT_AROUND).aroundAction((Action)this, consumer);
    }

    public final CisNextAction<S, E> nextAction(Action<S, E> nextAction) {
        return new DefaultCisNextAction<S, E>(this, null, nextAction);
    }

    public final CisNextAction<S, E> ifNextAction(Guard<S, E> actionGuard, Action<S, E> nextAction) {
        return new DefaultCisNextAction<S, E>(this, actionGuard, nextAction);
    }

    public final CisNextAction<S, E> ifElseNextAction(Guard<S, E> actionGuard, Action<S, E> nextAction, Action<S, E> elseAction) {
        return new DefaultCisNextAction<S, E>(this, actionGuard, nextAction, elseAction);
    }

    public final CisNextAction<S, E> next(Action<S, E> nextAction) {
        return new DefaultCisNextAction<S, E>(this, null, nextAction);
    }

    public final CisNextAction<S, E> ifNext(Guard<S, E> actionGuard, Action<S, E> nextAction) {
        return new DefaultCisNextAction<S, E>(this, actionGuard, nextAction);
    }

    public final CisNextAction<S, E> ifElseNext(Guard<S, E> actionGuard, Action<S, E> nextAction, Action<S, E> elseAction) {
        return new DefaultCisNextAction<S, E>(this, actionGuard, nextAction, elseAction);
    }

    public final CisNextAction<S, E> errorCatchFinally(Action<S, E> executeAction, Action<S, E> errorCatchAction, Action<S, E> finallyAction) {
        return new DefaultCisNextAction<S, E>(null, new DefaultCisErrorCatchAction<S, E>(executeAction, errorCatchAction, finallyAction));
    }

    public final CisNextAction<S, E> IfErrorCatchFinally(Guard<S, E> actionGuard, Action<S, E> executeAction, Action<S, E> errorCatchAction, Action<S, E> finallyAction) {
        return new DefaultCisNextAction<S, E>(actionGuard, new DefaultCisErrorCatchAction<S, E>(executeAction, errorCatchAction, finallyAction));
    }

    public abstract void executeSub(StateContext<S, E> var1);
}

