/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.action;

import com.dtyunxi.cube.statemachine.engine.action.CisErrorCatchAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;

public class DefaultCisErrorCatchAction<S, E>
implements CisErrorCatchAction<S, E> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCisErrorCatchAction.class);
    private final Action<S, E> executeAction;
    private final Action<S, E> errorExecuteAction;
    private final Action<S, E> finallyExecuteAction;

    public DefaultCisErrorCatchAction(Action<S, E> executeAction, Action<S, E> errorExecuteAction, Action<S, E> finallyExecuteAction) {
        if (executeAction == null) {
            throw new RuntimeException(this.getClass() + "\u914d\u7f6e\u5f02\u5e38executeAction");
        }
        if (errorExecuteAction == null) {
            throw new RuntimeException(this.getClass() + "\u914d\u7f6e\u5f02\u5e38errorExecuteAction");
        }
        this.executeAction = executeAction;
        this.errorExecuteAction = errorExecuteAction;
        this.finallyExecuteAction = finallyExecuteAction;
    }

    public void execute(StateContext<S, E> context) {
        logger.info("StatemachineLogTrack DefaultCisErrorCatchAction begin executeAction=" + this.executeAction.getClass() + " errorExecuteAction=" + this.errorExecuteAction.getClass());
        try {
            this.executeAction.execute(context);
        }
        catch (Throwable e) {
            this.errorExecuteAction.execute(context);
            throw e;
        }
        finally {
            logger.info("StatemachineLogTrack DefaultCisErrorCatchAction end executeAction=" + this.executeAction.getClass() + " errorExecuteAction=" + this.errorExecuteAction.getClass());
            if (this.finallyExecuteAction != null) {
                this.finallyExecuteAction.execute(context);
            }
        }
    }
}

