/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.action;

import com.dtyunxi.cube.statemachine.engine.action.CisErrorCatchAction;
import com.dtyunxi.cube.statemachine.engine.action.CisNextAction;
import com.dtyunxi.cube.statemachine.engine.action.DefaultCisErrorCatchAction;
import com.dtyunxi.cube.statemachine.engine.utils.CisActionContextUtils;
import java.util.Objects;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.guard.Guard;

public class DefaultCisNextAction<S, E>
implements CisNextAction<S, E> {
    protected DefaultCisNextAction<S, E> nextAction;
    protected Action<S, E> elseAction;
    protected Action<S, E> action;
    protected Guard<S, E> actionGuard;

    public DefaultCisNextAction(Action<S, E> action) {
        this.action = action;
    }

    public DefaultCisNextAction(Guard<S, E> actionGuard, Action<S, E> action) {
        this.action = action;
        this.actionGuard = actionGuard;
        this.elseAction = null;
    }

    public DefaultCisNextAction(Guard<S, E> actionGuard, Action<S, E> action, Action<S, E> elseAction) {
        this.action = action;
        this.actionGuard = actionGuard;
        this.elseAction = elseAction;
    }

    public DefaultCisNextAction(Action<S, E> action, Guard<S, E> nexGuard, Action<S, E> nexAction) {
        this.action = action;
        this.nextAction = new DefaultCisNextAction<S, E>(nexGuard, nexAction);
    }

    public DefaultCisNextAction(Action<S, E> action, Guard<S, E> nexGuard, Action<S, E> nexAction, Action<S, E> elseAction) {
        this.action = action;
        this.elseAction = elseAction;
        this.nextAction = new DefaultCisNextAction<S, E>(nexGuard, nexAction, elseAction);
    }

    public DefaultCisNextAction(Action<S, E> action, Guard<S, E> actionGuard, CisErrorCatchAction<S, E> errorCatchAction) {
        this.action = action;
        this.actionGuard = actionGuard;
        this.nextAction = new DefaultCisNextAction<S, E>(actionGuard, errorCatchAction);
        this.elseAction = null;
    }

    public DefaultCisNextAction(Guard<S, E> actionGuard, CisErrorCatchAction<S, E> errorCatchAction) {
        this.action = errorCatchAction;
        this.actionGuard = actionGuard;
        this.elseAction = null;
    }

    public void execute(StateContext<S, E> context) {
        if (Objects.nonNull(this.actionGuard)) {
            if (this.actionGuard.evaluate(context)) {
                this.action.execute(context);
            } else if (Objects.nonNull(this.elseAction)) {
                this.elseAction.execute(context);
            }
            CisActionContextUtils.checkGuardError(context);
        } else {
            this.action.execute(context);
        }
        if (Objects.nonNull(this.nextAction)) {
            this.nextAction.execute(context);
        }
    }

    @Override
    public final CisNextAction<S, E> next(Action<S, E> exAction) {
        if (this.nextAction == null) {
            this.nextAction = new DefaultCisNextAction<S, E>(exAction);
        } else {
            this.nextAction.next(exAction);
        }
        return this;
    }

    @Override
    public final CisNextAction<S, E> ifNext(Guard<S, E> actionGuard, Action<S, E> exAction) {
        if (this.nextAction == null) {
            this.nextAction = new DefaultCisNextAction<S, E>(actionGuard, exAction);
        } else {
            this.nextAction.ifNext(actionGuard, exAction);
        }
        return this;
    }

    @Override
    public final CisNextAction<S, E> ifElseNext(Guard<S, E> actionGuard, Action<S, E> ifAction, Action<S, E> elseAction) {
        if (this.nextAction == null) {
            this.nextAction = new DefaultCisNextAction<S, E>(actionGuard, ifAction, elseAction);
        } else {
            this.nextAction.ifElseNext(actionGuard, ifAction, elseAction);
        }
        return this;
    }

    @Override
    public CisNextAction<S, E> nextErrorFinallyCatchAction(Action<S, E> exAction, Action<S, E> errorAction, Action<S, E> finallyAction) {
        if (this.nextAction == null) {
            this.nextAction = new DefaultCisNextAction<S, E>(null, new DefaultCisErrorCatchAction<S, E>(exAction, errorAction, finallyAction));
        } else {
            this.nextAction.nextErrorFinallyCatchAction(exAction, errorAction, finallyAction);
        }
        return this;
    }

    @Override
    public CisNextAction<S, E> ifNextErrorFinallyCatchAction(Guard<S, E> actionGuard, Action<S, E> exAction, Action<S, E> errorAction, Action<S, E> finallyAction) {
        if (this.nextAction == null) {
            this.nextAction = new DefaultCisNextAction<S, E>(actionGuard, new DefaultCisErrorCatchAction<S, E>(exAction, errorAction, finallyAction));
        } else {
            this.nextAction.ifNextErrorFinallyCatchAction(actionGuard, exAction, errorAction, finallyAction);
        }
        return this;
    }

    public static <S, E> DefaultCisNextAction<S, E> SIMPLE(Action<S, E> action) {
        return new DefaultCisNextAction<S, E>(action);
    }
}

