/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.action.builder;

import com.dtyunxi.cube.statemachine.engine.action.AbstractCisBaseStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.AbstractCisRegisterEventStatemachineAction;
import com.dtyunxi.cube.statemachine.engine.action.CisActionDefine;
import com.dtyunxi.cube.statemachine.engine.enums.RegisterEventExecuteType;
import com.dtyunxi.cube.statemachine.engine.execute.CisStatemachineExecutor;
import com.dtyunxi.cube.statemachine.engine.transaction.CisTransactionManagerUtils;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisActionResult;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisRegisterEvent;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;

public class CisBaseActionBuilder {
    public static <S, E, ACTION extends CisActionDefine, REQ, RESP, THROUGH extends ThroughDtoDefine> AbstractCisBaseStatemachineAction<ACTION, S, E, REQ, RESP, THROUGH> build(ACTION actionDefine, BiFunction<THROUGH, REQ, RESP> function) {
        return CisBaseActionBuilder.build(false, actionDefine, function);
    }

    public static <S, E, ACTION extends CisActionDefine, REQ, RESP, THROUGH extends ThroughDtoDefine> AbstractCisBaseStatemachineAction<ACTION, S, E, REQ, RESP, THROUGH> build(boolean needTransaction, ACTION actionDefine, final BiFunction<THROUGH, REQ, RESP> function) {
        return new AbstractCisBaseStatemachineAction<ACTION, S, E, REQ, RESP, THROUGH>(actionDefine, needTransaction){

            @Override
            public RESP executeSub(THROUGH throughDto, REQ request) {
                return function.apply(throughDto, request);
            }
        };
    }

    public static <S, E, ACTION extends CisActionDefine, REQ, RESP, THROUGH extends ThroughDtoDefine> AbstractCisBaseStatemachineAction<ACTION, S, E, REQ, RESP, THROUGH> build4LastAction(ACTION actionDefine, BiFunction<THROUGH, REQ, RESP> function) {
        return CisBaseActionBuilder.build4LastAction(false, actionDefine, function);
    }

    public static <S, E, ACTION extends CisActionDefine, REQ, RESP, THROUGH extends ThroughDtoDefine> AbstractCisBaseStatemachineAction<ACTION, S, E, REQ, RESP, THROUGH> build4LastAction(boolean needTransaction, ACTION actionDefine, final BiFunction<THROUGH, REQ, RESP> function) {
        return new AbstractCisBaseStatemachineAction<ACTION, S, E, REQ, RESP, THROUGH>(actionDefine, needTransaction){

            @Override
            public RESP executeSub(THROUGH throughDto, REQ request) {
                return function.apply(throughDto, request);
            }

            @Override
            public REQ exchangeRequest(CisBaseOrderMessageHeaders<ACTION, S, E, ?, THROUGH> cisBaseOrderMessageHeaders, CisActionResult<ACTION, ?> lastCisActionResult) {
                return lastCisActionResult.getResultData();
            }
        };
    }

    public static <S, E, ACTION extends CisActionDefine, THROUGH extends ThroughDtoDefine> AbstractCisBaseStatemachineAction<ACTION, S, E, Object, Boolean, THROUGH> buildCommit(ACTION actionDefine) {
        return new AbstractCisBaseStatemachineAction<ACTION, S, E, Object, Boolean, THROUGH>(actionDefine, true){

            @Override
            public Boolean executeSub(THROUGH throughDto, Object request) {
                CisTransactionManagerUtils.actionTransactionCommit();
                return true;
            }
        };
    }

    public static <S, E, ACTION extends CisActionDefine, THROUGH extends ThroughDtoDefine> AbstractCisRegisterEventStatemachineAction<ACTION, S, E, Object, Object, THROUGH> buildEventRegister(final E event, final Object request, final Long throughId, final CisStatemachineExecutor cisStatemachineExecutor) {
        return new AbstractCisRegisterEventStatemachineAction<ACTION, S, E, Object, Object, THROUGH>(new Object[0]){

            @Override
            public List<CisRegisterEvent> exchangeRegisterEventList(CisBaseOrderMessageHeaders<ACTION, S, E, ?, THROUGH> cisBaseOrderMessageHeaders, CisActionResult<ACTION, ?> lastCisActionResult) {
                return Collections.singletonList(new CisRegisterEvent(event, request, throughId == null ? cisBaseOrderMessageHeaders.getThroughDto().getId() : throughId, cisStatemachineExecutor));
            }
        };
    }

    public static <S, E, ACTION extends CisActionDefine, THROUGH extends ThroughDtoDefine> AbstractCisRegisterEventStatemachineAction<ACTION, S, E, Object, Object, THROUGH> buildEventRegister4LastAction(final E event, final Long throughId, final CisStatemachineExecutor cisStatemachineExecutor) {
        return new AbstractCisRegisterEventStatemachineAction<ACTION, S, E, Object, Object, THROUGH>(new Object[0]){

            @Override
            public List<CisRegisterEvent> exchangeRegisterEventList(CisBaseOrderMessageHeaders<ACTION, S, E, ?, THROUGH> cisBaseOrderMessageHeaders, CisActionResult<ACTION, ?> lastCisActionResult) {
                return Collections.singletonList(new CisRegisterEvent(event, lastCisActionResult.getResultData(), throughId == null ? cisBaseOrderMessageHeaders.getThroughDto().getId() : throughId, cisStatemachineExecutor));
            }
        };
    }

    public static <S, E, ACTION extends CisActionDefine, THROUGH extends ThroughDtoDefine> AbstractCisRegisterEventStatemachineAction<ACTION, S, E, Object, Object, THROUGH> buildEventRegister(final E event, final Long throughId, final CisStatemachineExecutor cisStatemachineExecutor, final String bizModel, final RegisterEventExecuteType registerEventExecuteType) {
        return new AbstractCisRegisterEventStatemachineAction<ACTION, S, E, Object, Object, THROUGH>(new Object[0]){

            @Override
            public List<CisRegisterEvent> exchangeRegisterEventList(CisBaseOrderMessageHeaders<ACTION, S, E, ?, THROUGH> cisBaseOrderMessageHeaders, CisActionResult<ACTION, ?> lastCisActionResult) {
                return Collections.singletonList(new CisRegisterEvent(event, null, throughId == null ? cisBaseOrderMessageHeaders.getThroughDto().getId() : throughId, cisStatemachineExecutor, bizModel, registerEventExecuteType));
            }
        };
    }
}

