/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.statemachine.engine.execute;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.statemachine.engine.exception.CisStatemachineExceptionCode;
import com.dtyunxi.cube.statemachine.engine.execute.AsyncEventRegisterExecutor;
import com.dtyunxi.cube.statemachine.engine.execute.CisStatemachineExecutor;
import com.dtyunxi.cube.statemachine.engine.handler.StatemachineEventExecuteRecordHandler;
import com.dtyunxi.cube.statemachine.engine.listener.StatemachineEventExecuteListener;
import com.dtyunxi.cube.statemachine.engine.transaction.CisTransactionManagerUtils;
import com.dtyunxi.cube.statemachine.engine.vo.ThroughDtoDefine;
import com.dtyunxi.cube.statemachine.engine.vo.header.CisBaseOrderMessageHeaders;
import com.dtyunxi.cube.statemachine.engine.vo.listener.EventExecuteListenerVo;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisGuardResult;
import com.dtyunxi.cube.statemachine.engine.vo.result.CisRegisterEvent;
import com.dtyunxi.cube.statemachine.engine.vo.simple.SimpleThroughDtoDefine;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineEventResult;
import org.springframework.statemachine.config.StateMachineBuilder;
import reactor.core.publisher.Mono;

public abstract class AbstractCisStatemachineExecutor<S, E, THR extends ThroughDtoDefine>
implements CisStatemachineExecutor<S, E> {
    private static Logger logger = LoggerFactory.getLogger(AbstractCisStatemachineExecutor.class);
    private ThreadLocal<AtomicLong> EXECUTE_LEVEL = new ThreadLocal();
    @Resource
    private AsyncEventRegisterExecutor asyncEventRegisterExecutor;
    protected StatemachineEventExecuteListener<S, E, THR> statemachineEventExecuteListener;
    protected StatemachineEventExecuteRecordHandler statemachineEventExecuteRecordHandler;

    public AbstractCisStatemachineExecutor() {
    }

    public AbstractCisStatemachineExecutor(StatemachineEventExecuteListener<S, E, THR> statemachineEventExecuteListener) {
        this.statemachineEventExecuteListener = statemachineEventExecuteListener;
    }

    public AbstractCisStatemachineExecutor(StatemachineEventExecuteListener<S, E, THR> statemachineEventExecuteListener, StatemachineEventExecuteRecordHandler statemachineEventExecuteRecordHandler) {
        this.statemachineEventExecuteListener = statemachineEventExecuteListener;
        this.statemachineEventExecuteRecordHandler = statemachineEventExecuteRecordHandler;
    }

    public StatemachineEventExecuteListener<S, E, THR> getStatemachineEventExecuteListener() {
        return this.statemachineEventExecuteListener;
    }

    public <RQ> CisBaseOrderMessageHeaders<?, S, E, RQ, THR> executeStatemachine(String bizModel, Long throughDtoId, RQ request, E event) {
        return this.executeStatemachine(new StatemachineEventExecuteDto(new AtomicLong(0L), new CisRegisterEvent(event, request, throughDtoId, (CisStatemachineExecutor)this)), bizModel, throughDtoId, request, event);
    }

    public <RQ> CisBaseOrderMessageHeaders<?, S, E, RQ, ?> executeStatemachine(CisRegisterEvent cisRegisterEvent) {
        return this.executeStatemachine(new StatemachineEventExecuteDto(new AtomicLong(0L), cisRegisterEvent), cisRegisterEvent.getBizModel(), cisRegisterEvent.getThoughDtoId(), cisRegisterEvent.getRequest(), cisRegisterEvent.getRegisterEvent());
    }

    public final <RQ> CisBaseOrderMessageHeaders<?, S, E, RQ, THR> executeStatemachine(StatemachineEventExecuteDto statemachineEventExecuteDto, String bizModel, Long throughDtoId, RQ request, E event) {
        StateMachine nowStateMachine = this.assemblyStatemachineBuilder(bizModel, throughDtoId, request, event).build();
        CisBaseOrderMessageHeaders<?, S, E, RQ, THR> cisBaseOrderMessageHeaders = this.buildMessageHeaders(bizModel, throughDtoId, request, event);
        cisBaseOrderMessageHeaders.putBizHeader("EVENT_MESSAGE_HEADER_VO_BIZ_MAP_KEY_BIZ_MODEL", (Object)bizModel);
        cisBaseOrderMessageHeaders.putBizHeader("EVENT_MESSAGE_HEADER_VO_BIZ_MAP_KEY_STATE_MACHINE_EXECUTOR", (Object)this);
        cisBaseOrderMessageHeaders.putBizHeader("EVENT_MESSAGE_HEADER_VO_THOUGH_ID", (Object)throughDtoId);
        this.restoreStatemachine(throughDtoId, nowStateMachine, cisBaseOrderMessageHeaders);
        Mono stateMachineEventResultList = nowStateMachine.sendEventCollect(Mono.just((Object)MessageBuilder.withPayload(event).copyHeaders(this.buildContextHeaders(cisBaseOrderMessageHeaders)).setHeader("EVENT_MESSAGE_HEADER_VO_KEY", cisBaseOrderMessageHeaders).build()));
        this.executeEvent(statemachineEventExecuteDto, nowStateMachine, bizModel, event, cisBaseOrderMessageHeaders, stateMachineEventResultList);
        this.executeRegisterEvent(statemachineEventExecuteDto, bizModel, cisBaseOrderMessageHeaders);
        return cisBaseOrderMessageHeaders;
    }

    private <RQ> void executeEvent(StatemachineEventExecuteDto statemachineEventExecuteDto, StateMachine<S, E> nowStateMachine, String bizModel, E event, CisBaseOrderMessageHeaders<?, S, E, RQ, THR> cisBaseOrderMessageHeaders, Mono<List<StateMachineEventResult<S, E>>> stateMachineEventResultList) {
        Throwable throwable = null;
        Object preState = nowStateMachine.getState().getId();
        Date preTime = new Date();
        Date endTime = null;
        try {
            this.preEventExecute(preTime, statemachineEventExecuteDto.getCisRegisterEvent(), preState, bizModel, event, cisBaseOrderMessageHeaders);
            List<StateMachineEventResult<S, E>> stateMachineEventResults = this.aroundExecute(cisBaseOrderMessageHeaders, obj -> (List)stateMachineEventResultList.block());
            endTime = new Date();
            this.assertStatemachineResult(Optional.ofNullable(stateMachineEventResults).orElseGet(ArrayList::new), cisBaseOrderMessageHeaders, event);
            if (CisTransactionManagerUtils.checkHadTransaction()) {
                CisTransactionManagerUtils.actionTransactionRollback();
                logger.warn("\u4e8b\u4ef6\u6d41\u7a0b\u7ed3\u675f\u540e\u4e8b\u52a1\u8fd8\u6ca1\u63d0\u4ea4\uff0c\u624b\u52a8\u56de\u6eda\u4e8b\u52a1", (Throwable)new BizException(event + "\u4e8b\u52a1\u914d\u7f6e\u5f02\u5e38"));
            }
            this.checkStatemachineExecuteResult(cisBaseOrderMessageHeaders);
        }
        catch (Throwable e) {
            throwable = e;
            throw e;
        }
        finally {
            endTime = Optional.ofNullable(endTime).orElseGet(Date::new);
            this.endEventExecute(preTime, endTime, statemachineEventExecuteDto.getCisRegisterEvent(), preState, nowStateMachine.getState().getId(), bizModel, event, cisBaseOrderMessageHeaders, throwable);
        }
    }

    public final <RQ> void executeRegisterEvent(StatemachineEventExecuteDto statemachineEventExecuteDto, String bizModel, CisBaseOrderMessageHeaders<?, S, E, RQ, THR> cisBaseOrderMessageHeaders) {
        Optional.ofNullable(cisBaseOrderMessageHeaders.getRegisterEventList()).ifPresent(eventList -> {
            if (statemachineEventExecuteDto.getExeLevel().incrementAndGet() > 20L) {
                throw new RuntimeException("event\u6ce8\u518c\u4e8b\u4ef6\u6267\u884c\u5c42\u7ea7\u5f02\u5e38\uff0c\u5df2\u8d85\u8fc720\u5c42\uff0ceventList={}" + JSON.toJSONString((Object)eventList));
            }
            logger.info("StatemachineLogTrack " + cisBaseOrderMessageHeaders.getEvent() + " executeRegisterEvent={}", (Object)JSON.toJSONString((Object)eventList));
            eventList.forEach(event -> {
                switch (event.getRegisterEventType()) {
                    case SYNC: {
                        this.executeSerqthrCisBaseOrderMessageHeaders(new StatemachineEventExecuteDto(new AtomicLong(statemachineEventExecuteDto.getExeLevel().longValue()), (CisRegisterEvent)event), bizModel, (CisRegisterEvent)event);
                        break;
                    }
                    case SYNC_POLLING: {
                        try {
                            this.executeSerqthrCisBaseOrderMessageHeaders(new StatemachineEventExecuteDto(new AtomicLong(statemachineEventExecuteDto.getExeLevel().longValue()), (CisRegisterEvent)event), bizModel, (CisRegisterEvent)event);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        break;
                    }
                    case ASYNC: {
                        ConcurrentHashMap<String, Object> localParams = new ConcurrentHashMap<String, Object>();
                        localParams.put("yes.req.requestId", ServiceContext.getContext().getRequestId());
                        this.asyncEventRegisterExecutor.executeEvent(new StatemachineEventExecuteDto(new AtomicLong(statemachineEventExecuteDto.getExeLevel().longValue()), (CisRegisterEvent)event), bizModel, this, (CisRegisterEvent)event, (Map<String, Object>)localParams);
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u672a\u914d\u7f6e\u4e8b\u4ef6\u6ce8\u518c\u6267\u884c\u7c7b\u578b" + event.getRegisterEventType());
                    }
                }
            });
        });
    }

    private <RQ> CisBaseOrderMessageHeaders<?, S, E, RQ, THR> executeSerqthrCisBaseOrderMessageHeaders(StatemachineEventExecuteDto statemachineEventExecuteDto, String bizModel, CisRegisterEvent event) {
        CisBaseOrderMessageHeaders<?, S, Object, Object, THR> serqthrCisBaseOrderMessageHeaders = null;
        serqthrCisBaseOrderMessageHeaders = event.getCisStatemachineExecutor() == null ? this.executeStatemachine(statemachineEventExecuteDto, StringUtils.isBlank((CharSequence)event.getBizModel()) ? bizModel : event.getBizModel(), event.getThoughDtoId(), event.getRequest(), event.getRegisterEvent()) : ((AbstractCisStatemachineExecutor)event.getCisStatemachineExecutor()).executeStatemachine(statemachineEventExecuteDto, StringUtils.isBlank((CharSequence)event.getBizModel()) ? bizModel : event.getBizModel(), event.getThoughDtoId(), event.getRequest(), event.getRegisterEvent());
        serqthrCisBaseOrderMessageHeaders.checkStatemachineExecuteResult();
        return serqthrCisBaseOrderMessageHeaders;
    }

    public <RQ> CisBaseOrderMessageHeaders<?, S, E, RQ, THR> buildMessageHeaders(String bizModel, Long throughDtoId, RQ request, E event) {
        return new CisBaseOrderMessageHeaders((ThroughDtoDefine)new SimpleThroughDtoDefine(throughDtoId), request, event);
    }

    public void restoreStatemachine(Long throughDtoId, StateMachine<S, E> nowStateMachine, CisBaseOrderMessageHeaders<?, S, E, ?, THR> cisBaseOrderMessageHeaders) {
    }

    public Map<String, Object> buildContextHeaders(CisBaseOrderMessageHeaders<?, S, E, ?, THR> cisBaseOrderMessageHeaders) {
        return new ConcurrentHashMap<String, Object>();
    }

    public void checkStatemachineExecuteResult(CisBaseOrderMessageHeaders<?, S, E, ?, THR> cisBaseOrderMessageHeaders) {
        cisBaseOrderMessageHeaders.checkStatemachineExecuteResult();
    }

    public void assertStatemachineResult(List<StateMachineEventResult<S, E>> stateMachineEventResults, CisBaseOrderMessageHeaders<?, S, E, ?, THR> cisBaseOrderMessageHeaders, E event) {
        stateMachineEventResults.forEach(result -> {
            logger.info("executeStatemachine block>>>>>>message={},resultType={},region={}", new Object[]{result.getMessage(), result.getResultType(), result.getRegion()});
            if (CollectionUtils.isEmpty((Collection)cisBaseOrderMessageHeaders.getAllActionResultList()) && Objects.equals(result.getResultType(), StateMachineEventResult.ResultType.DENIED)) {
                if (CollectionUtils.isNotEmpty((Collection)cisBaseOrderMessageHeaders.getAllGuardResultList())) {
                    throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{this.buildNotThroughGuardMessage(cisBaseOrderMessageHeaders, event)});
                }
                throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{this.buildNotAcceptMessage(cisBaseOrderMessageHeaders, event)});
            }
            if (CollectionUtils.isNotEmpty((Collection)cisBaseOrderMessageHeaders.getAllGuardResultList()) && Objects.equals(result.getResultType(), StateMachineEventResult.ResultType.ACCEPTED)) {
                throw CisStatemachineExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{this.buildNotThroughGuardMessage(cisBaseOrderMessageHeaders, event)});
            }
        });
    }

    public String buildNotAcceptMessage(CisBaseOrderMessageHeaders<?, S, E, ?, THR> cisBaseOrderMessageHeaders, E event) {
        return "\u5f53\u524d\u72b6\u6001'" + Optional.ofNullable(cisBaseOrderMessageHeaders.getThroughDto().getStateDefine()).orElse("\u521d\u59cb\u5316") + "'\u4e0d\u5141\u8bb8'" + event + "'\u64cd\u4f5c";
    }

    public String buildNotThroughGuardMessage(CisBaseOrderMessageHeaders<?, S, E, ?, THR> cisBaseOrderMessageHeaders, E event) {
        return "\u5f53\u524d\u72b6\u6001'" + Optional.ofNullable(cisBaseOrderMessageHeaders.getThroughDto().getStateDefine()).orElse("\u521d\u59cb\u5316") + "'\u6267\u884c'" + event + "'\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + Optional.ofNullable(cisBaseOrderMessageHeaders.getLastGuardResultSub()).map(gr -> ((CisGuardResult)gr.getResultData()).getGuardFalseMessage()).orElse("\u5b88\u536b\u89c4\u5219\u672a\u901a\u8fc7");
    }

    public List<StateMachineEventResult<S, E>> aroundExecute(CisBaseOrderMessageHeaders<?, S, E, ?, THR> cisBaseOrderMessageHeaders, Function<?, List<StateMachineEventResult<S, E>>> fu) {
        return fu.apply(null);
    }

    public void preEventExecute(Date preTime, CisRegisterEvent cisRegisterEvent, S preState, String bizModel, E event, CisBaseOrderMessageHeaders<?, S, E, ?, THR> cisBaseOrderMessageHeaders) {
        Optional.ofNullable(this.statemachineEventExecuteListener).ifPresent(listener -> listener.preEventExecute(this.buildEventExecuteListenerVo(preTime, null, cisRegisterEvent, preState, null, bizModel, event, cisBaseOrderMessageHeaders, null)));
    }

    public void endEventExecute(Date preTime, Date endTime, CisRegisterEvent cisRegisterEvent, S preState, S endState, String bizModel, E event, CisBaseOrderMessageHeaders<?, S, E, ?, THR> cisBaseOrderMessageHeaders, Throwable throwable) {
        Optional.ofNullable(this.statemachineEventExecuteListener).ifPresent(listener -> listener.endEventExecute(this.buildEventExecuteListenerVo(preTime, endTime, cisRegisterEvent, preState, endState, bizModel, event, cisBaseOrderMessageHeaders, throwable)));
    }

    private EventExecuteListenerVo<S, E, THR> buildEventExecuteListenerVo(Date preTime, Date endTime, CisRegisterEvent cisRegisterEvent, S preState, S endState, String bizModel, E event, CisBaseOrderMessageHeaders<?, S, E, ?, THR> cisBaseOrderMessageHeaders, Throwable throwable) {
        return EventExecuteListenerVo.builder().cisRegisterEvent(cisRegisterEvent).event(event).preTime(preTime).endTime(endTime).preState(preState).endState(endState).bizModel(bizModel).cisBaseOrderMessageHeaders(cisBaseOrderMessageHeaders).throwable(throwable).build();
    }

    public CisBaseOrderMessageHeaders<?, S, E, ?, ?> executeStatemachineByEventRecordId(Long eventRecordId) throws Exception {
        if (this.statemachineEventExecuteRecordHandler == null) {
            throw new RuntimeException("\u4e8b\u4ef6\u6267\u884c\u5668\u672a\u521d\u59cb\u5316");
        }
        return this.statemachineEventExecuteRecordHandler.retryEventExecute((CisStatemachineExecutor)this, eventRecordId);
    }

    public abstract <RQ> StateMachineBuilder.Builder<S, E> assemblyStatemachineBuilder(String var1, Long var2, RQ var3, E var4);

    public static class StatemachineEventExecuteDto
    extends BaseVo {
        private AtomicLong exeLevel;
        private CisRegisterEvent cisRegisterEvent;

        public StatemachineEventExecuteDto(AtomicLong exeLevel, CisRegisterEvent cisRegisterEvent) {
            this.exeLevel = exeLevel;
            this.cisRegisterEvent = cisRegisterEvent;
        }

        public AtomicLong getExeLevel() {
            return this.exeLevel;
        }

        public void setExeLevel(AtomicLong exeLevel) {
            this.exeLevel = exeLevel;
        }

        public CisRegisterEvent getCisRegisterEvent() {
            return this.cisRegisterEvent;
        }

        public void setCisRegisterEvent(CisRegisterEvent cisRegisterEvent) {
            this.cisRegisterEvent = cisRegisterEvent;
        }
    }
}

